/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;

public abstract class Foldables {
    public static Object valueOf(FoldContext ctx, Expression e) {
        if (e.foldable()) {
            return e.fold(ctx);
        }
        throw new QlIllegalArgumentException("Cannot determine value for {}", new Object[]{e});
    }

    public static String stringLiteralValueOf(Expression expression, String message) {
        Literal literal;
        Object object;
        if (expression instanceof Literal && (object = (literal = (Literal)expression).value()) instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)object;
            return bytesRef.utf8ToString();
        }
        throw new QlIllegalArgumentException(message);
    }

    public static Object literalValueOf(Expression e) {
        if (e instanceof Literal) {
            Literal literal = (Literal)e;
            return literal.value();
        }
        throw new QlIllegalArgumentException("Expected literal, but got {}", new Object[]{e});
    }

    public static Object extractLiteralOrReturnSelf(Expression e) {
        if (e instanceof Literal) {
            Literal literal = (Literal)e;
            return literal.value();
        }
        return e;
    }

    public static Integer limitValue(Expression limitField, String sourceText) {
        Literal literal;
        Object value;
        if (limitField instanceof Literal && (value = (literal = (Literal)limitField).value()) instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue;
        }
        throw new EsqlIllegalArgumentException(LoggerMessageFormat.format(null, (String)"Limit value must be an integer in [{}], found [{}]", (Object[])new Object[]{sourceText, limitField}));
    }

    public static Expression.TypeResolution resolveTypeLimit(Expression limitField, String sourceText, TypeResolutionValidator validator) {
        if (limitField == null) {
            validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Limit must be a constant integer in [{}], found [{}]", (Object[])new Object[]{sourceText, limitField})));
        } else if (limitField instanceof Literal) {
            Literal literal = (Literal)limitField;
            if (literal.value() == null) {
                validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Limit must be a constant integer in [{}], found [{}]", (Object[])new Object[]{sourceText, limitField})));
            } else {
                int value = (Integer)literal.value();
                if (value <= 0) {
                    validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Limit must be greater than 0 in [{}], found [{}]", (Object[])new Object[]{sourceText, value})));
                }
            }
        } else {
            validator.invalidIfPostValidation(Failure.fail(limitField, "Limit must be a constant integer in [{}], found [{}]", new Object[]{sourceText, limitField}));
        }
        return validator.getResolvedType();
    }

    public static Expression.TypeResolution resolveTypeQuery(Expression queryField, String sourceText, TypeResolutionValidator validator) {
        if (queryField == null) {
            validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Query must be a valid string in [{}], found [{}]", (Object[])new Object[]{sourceText, queryField})));
        } else if (queryField instanceof Literal) {
            Literal literal = (Literal)queryField;
            if (literal.value() == null) {
                validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Query value cannot be null in [{}], but got [{}]", (Object[])new Object[]{sourceText, queryField})));
            }
        } else {
            validator.invalidIfPostValidation(Failure.fail(queryField, "Query must be a valid string in [{}], found [{}]", new Object[]{sourceText, queryField}));
        }
        return validator.getResolvedType();
    }

    public static Object queryAsObject(Expression queryField, String sourceText) {
        if (queryField instanceof Literal) {
            Literal literal = (Literal)queryField;
            return literal.value();
        }
        throw new EsqlIllegalArgumentException(LoggerMessageFormat.format(null, (String)"Query value must be a constant string in [{}], found [{}]", (Object[])new Object[]{sourceText, queryField}));
    }

    public static String queryAsString(Expression queryField, String sourceText) {
        if (queryField instanceof Literal) {
            Literal literal = (Literal)queryField;
            return BytesRefs.toString((Object)literal.value());
        }
        throw new EsqlIllegalArgumentException(LoggerMessageFormat.format(null, (String)"Query value must be a constant string in [{}], found [{}]", (Object[])new Object[]{sourceText, queryField}));
    }

    public static int intValueOf(Expression field, String sourceText, String fieldName) {
        Literal literal;
        Object object;
        if (field instanceof Literal && (object = (literal = (Literal)field).value()) instanceof Number) {
            Number n = (Number)object;
            return n.intValue();
        }
        throw new EsqlIllegalArgumentException(Strings.format(null, (Object[])new Object[]{"[{}] value must be a constant number in [{}], found [{}]", fieldName, sourceText, field}));
    }

    public static double doubleValueOf(Expression field, String sourceText, String fieldName) {
        Literal literal;
        Object object;
        if (field instanceof Literal && (object = (literal = (Literal)field).value()) instanceof Number) {
            Number n = (Number)object;
            return n.doubleValue();
        }
        throw new EsqlIllegalArgumentException(Strings.format(null, (Object[])new Object[]{"[{}] value must be a constant number in [{}], found [{}]", fieldName, sourceText, field}));
    }

    public static class TypeResolutionValidator {
        Expression.TypeResolution typeResolution = Expression.TypeResolution.TYPE_RESOLVED;
        @Nullable
        private final Failures postValidationFailures;
        private final Expression field;

        public static TypeResolutionValidator forPreOptimizationValidation(Expression field) {
            return new TypeResolutionValidator(field, null);
        }

        public static TypeResolutionValidator forPostOptimizationValidation(Expression field, Failures failures) {
            return new TypeResolutionValidator(field, failures);
        }

        private TypeResolutionValidator(Expression field, Failures failures) {
            this.field = field;
            this.postValidationFailures = failures;
        }

        public void invalidIfPostValidation(Failure failure) {
            if (this.postValidationFailures != null) {
                this.postValidationFailures.add(failure);
            }
        }

        public void invalid(Expression.TypeResolution message) {
            this.typeResolution = message;
            if (this.postValidationFailures != null) {
                this.postValidationFailures.add(Failure.fail(this.field, message.message(), new Object[0]));
            }
        }

        public Expression.TypeResolution getResolvedType() {
            return this.typeResolution;
        }
    }
}

