/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichMetadata;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;
import org.elasticsearch.xpack.esql.session.IndexResolver;

public class EnrichPolicyResolver {
    private static final String RESOLVE_ACTION_NAME = "cluster:monitor/xpack/enrich/esql/resolve_policy";
    private final ClusterService clusterService;
    private final IndexResolver indexResolver;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final RemoteClusterService remoteClusterService;
    private final ProjectResolver projectResolver;

    public EnrichPolicyResolver(ClusterService clusterService, TransportService transportService, IndexResolver indexResolver, ProjectResolver projectResolver) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexResolver = indexResolver;
        this.threadPool = transportService.getThreadPool();
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.projectResolver = projectResolver;
        transportService.registerRequestHandler(RESOLVE_ACTION_NAME, (Executor)this.threadPool.executor("search"), LookupRequest::new, (TransportRequestHandler)new RequestHandler());
    }

    public void resolvePolicies(List<Enrich> enriches, EsqlExecutionInfo executionInfo, ActionListener<EnrichResolution> listener) {
        if (enriches.isEmpty()) {
            listener.onResponse((Object)new EnrichResolution());
            return;
        }
        this.doResolvePolicies(executionInfo.clusterInfo.isEmpty() ? new HashSet() : executionInfo.getRunningClusterAliases().collect(Collectors.toSet()), enriches.stream().map(UnresolvedPolicy::from).toList(), executionInfo, listener);
    }

    protected void doResolvePolicies(Set<String> remoteClusters, Collection<UnresolvedPolicy> unresolvedPolicies, EsqlExecutionInfo executionInfo, ActionListener<EnrichResolution> listener) {
        if (unresolvedPolicies.isEmpty()) {
            listener.onResponse((Object)new EnrichResolution());
            return;
        }
        boolean includeLocal = remoteClusters.isEmpty() || remoteClusters.remove("");
        this.lookupPolicies(remoteClusters, includeLocal, unresolvedPolicies, executionInfo, (ActionListener<Map<String, LookupResponse>>)listener.map(lookupResponses -> {
            EnrichResolution enrichResolution = new EnrichResolution();
            HashMap<String, LookupResponse> lookupResponsesToProcess = new HashMap<String, LookupResponse>();
            for (Map.Entry entry : lookupResponses.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                if (((LookupResponse)((Object)((Object)entry.getValue()))).connectionError != null) {
                    assert (!clusterAlias.equals("")) : "Should never have a connection error for the local cluster";
                    EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, clusterAlias, EsqlExecutionInfo.Cluster.Status.SKIPPED, ((LookupResponse)((Object)((Object)entry.getValue()))).connectionError);
                    remoteClusters.remove(clusterAlias);
                    continue;
                }
                lookupResponsesToProcess.put(clusterAlias, (LookupResponse)((Object)((Object)entry.getValue())));
            }
            for (UnresolvedPolicy unresolved : unresolvedPolicies) {
                Tuple<ResolvedEnrichPolicy, String> resolved = this.mergeLookupResults(unresolved, this.calculateTargetClusters(unresolved.mode, includeLocal, remoteClusters), lookupResponsesToProcess);
                if (resolved.v1() != null) {
                    enrichResolution.addResolvedPolicy(unresolved.name, unresolved.mode, (ResolvedEnrichPolicy)resolved.v1());
                    continue;
                }
                assert (resolved.v2() != null);
                enrichResolution.addError(unresolved.name, unresolved.mode, (String)resolved.v2());
            }
            return enrichResolution;
        }));
    }

    private Collection<String> calculateTargetClusters(Enrich.Mode mode, boolean includeLocal, Set<String> remoteClusters) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case Enrich.Mode.ANY -> CollectionUtils.appendToCopy(remoteClusters, (Object)"");
            case Enrich.Mode.COORDINATOR -> List.of("");
            case Enrich.Mode.REMOTE -> includeLocal ? CollectionUtils.appendToCopy(remoteClusters, (Object)"") : remoteClusters;
        };
    }

    private Tuple<ResolvedEnrichPolicy, String> mergeLookupResults(UnresolvedPolicy unresolved, Collection<String> targetClusters, Map<String, LookupResponse> lookupResults) {
        String policyName = unresolved.name;
        if (targetClusters.isEmpty()) {
            return Tuple.tuple(null, (Object)("enrich policy [" + policyName + "] cannot be resolved since remote clusters are unavailable"));
        }
        HashMap<String, Object> policies = new HashMap<String, Object>();
        ArrayList<String> failures = new ArrayList<String>();
        for (String cluster : targetClusters) {
            LookupResponse lookupResult = lookupResults.get(cluster);
            if (lookupResult == null) continue;
            assert (lookupResult.connectionError == null) : "Should never have a non-null connectionError here";
            ResolvedEnrichPolicy policy = lookupResult.policies.get(policyName);
            if (policy != null) {
                policies.put(cluster, policy);
                continue;
            }
            String string = lookupResult.failures.get(policyName);
            if (string == null) continue;
            failures.add(string);
        }
        if (targetClusters.size() != policies.size()) {
            Object reason;
            if (failures.isEmpty()) {
                List<String> missingClusters = targetClusters.stream().filter(c -> !policies.containsKey(c)).sorted().toList();
                reason = this.missingPolicyError(policyName, targetClusters, missingClusters);
            } else {
                reason = "failed to resolve enrich policy [" + policyName + "]; reason " + String.valueOf(failures);
            }
            return Tuple.tuple(null, (Object)reason);
        }
        HashMap<String, EsField> mappings = new HashMap<String, EsField>();
        HashMap<String, String> concreteIndices = new HashMap<String, String>();
        ResolvedEnrichPolicy last = null;
        for (Map.Entry entry : policies.entrySet()) {
            Object error;
            ResolvedEnrichPolicy curr = (ResolvedEnrichPolicy)entry.getValue();
            if (last != null && !last.matchField().equals(curr.matchField())) {
                error = "enrich policy [" + policyName + "] has different match fields ";
                error = (String)error + "[" + last.matchField() + ", " + curr.matchField() + "] across clusters";
                return Tuple.tuple(null, (Object)error);
            }
            if (last != null && !last.matchType().equals(curr.matchType())) {
                error = "enrich policy [" + policyName + "] has different match types ";
                error = (String)error + "[" + last.matchType() + ", " + curr.matchType() + "] across clusters";
                return Tuple.tuple(null, (Object)error);
            }
            for (Map.Entry entry2 : curr.mapping().entrySet()) {
                EsField field = (EsField)entry2.getValue();
                field = new EsField(field.getName(), DataType.fromTypeName((String)field.getDataType().typeName()), field.getProperties(), field.isAggregatable(), field.isAlias(), field.getTimeSeriesFieldType());
                EsField old = mappings.putIfAbsent((String)entry2.getKey(), field);
                if (old == null || old.getDataType().equals((Object)field.getDataType())) continue;
                String error2 = "field [" + (String)entry2.getKey() + "] of enrich policy [" + policyName + "] has different data types ";
                error2 = error2 + "[" + String.valueOf(old.getDataType()) + ", " + String.valueOf(field.getDataType()) + "] across clusters";
                return Tuple.tuple(null, (Object)error2);
            }
            if (last != null) {
                Map counts = Maps.newMapWithExpectedSize((int)last.enrichFields().size());
                last.enrichFields().forEach(f -> counts.put(f, 1));
                curr.enrichFields().forEach(f -> counts.compute(f, (k, v) -> v == null ? 1 : v + 1));
                List<String> list = counts.entrySet().stream().filter(f -> (Integer)f.getValue() < 2).map(Map.Entry::getKey).limit(20L).sorted().toList();
                if (!list.isEmpty()) {
                    String detailed = "these fields are missing in some policies: " + String.valueOf(list);
                    return Tuple.tuple(null, (Object)("enrich policy [" + policyName + "] has different enrich fields across clusters; " + detailed));
                }
            }
            concreteIndices.putAll(curr.concreteIndices());
            last = curr;
        }
        assert (last != null);
        ResolvedEnrichPolicy resolved = new ResolvedEnrichPolicy(last.matchField(), last.matchType(), last.enrichFields(), concreteIndices, mappings);
        return Tuple.tuple((Object)resolved, null);
    }

    private String missingPolicyError(String policyName, Collection<String> targetClusters, List<String> missingClusters) {
        String reason = "cannot find enrich policy [" + policyName + "]";
        if (targetClusters.size() == 1 && ((String)Iterables.get(missingClusters, (int)0)).isEmpty()) {
            List potentialMatches = StringUtils.findSimilar((String)policyName, this.availablePolicies().keySet());
            if (!potentialMatches.isEmpty()) {
                String suggestion = potentialMatches.size() == 1 ? "[" + (String)potentialMatches.get(0) + "]" : "any of " + String.valueOf(potentialMatches);
                reason = reason + ", did you mean " + suggestion + "?";
            }
            return reason;
        }
        String detailed = missingClusters.stream().sorted().map(c -> c.isEmpty() ? "_local" : c).collect(Collectors.joining(", "));
        return reason + " on clusters [" + detailed + "]";
    }

    private void lookupPolicies(Collection<String> remoteClusters, boolean includeLocal, Collection<UnresolvedPolicy> unresolvedPolicies, EsqlExecutionInfo executionInfo, ActionListener<Map<String, LookupResponse>> listener) {
        ConcurrentMap lookupResponses = ConcurrentCollections.newConcurrentMap();
        try (RefCountingListener refs = new RefCountingListener(listener.map(unused -> lookupResponses));){
            Set<String> localPolicies;
            final Set remotePolicies = unresolvedPolicies.stream().filter(u -> u.mode != Enrich.Mode.COORDINATOR).map(u -> u.name).collect(Collectors.toSet());
            if (!remotePolicies.isEmpty()) {
                for (final String cluster : remoteClusters) {
                    final boolean skipOnFailure = executionInfo.shouldSkipOnFailure(cluster);
                    final ActionListener lookupListener = refs.acquire(resp -> lookupResponses.put(cluster, resp));
                    this.getRemoteConnection(cluster, !skipOnFailure, new ActionListener<Transport.Connection>(){

                        public void onResponse(Transport.Connection connection) {
                            EnrichPolicyResolver.this.transportService.sendRequest(connection, EnrichPolicyResolver.RESOLVE_ACTION_NAME, (TransportRequest)new LookupRequest(cluster, remotePolicies), TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(lookupListener.delegateResponse((l, e) -> EnrichPolicyResolver.this.failIfSkipUnavailableFalse((Exception)e, skipOnFailure, (ActionListener<LookupResponse>)l)), LookupResponse::new, (Executor)EnrichPolicyResolver.this.threadPool.executor("search")));
                        }

                        public void onFailure(Exception e) {
                            EnrichPolicyResolver.this.failIfSkipUnavailableFalse(e, skipOnFailure, (ActionListener<LookupResponse>)lookupListener);
                        }
                    });
                }
            }
            if (!(localPolicies = unresolvedPolicies.stream().filter(u -> includeLocal || u.mode != Enrich.Mode.REMOTE).map(u -> u.name).collect(Collectors.toSet())).isEmpty()) {
                this.transportService.sendRequest(this.transportService.getLocalNode(), RESOLVE_ACTION_NAME, (TransportRequest)new LookupRequest("", localPolicies), (TransportResponseHandler)new ActionListenerResponseHandler(refs.acquire(resp -> lookupResponses.put("", resp)), LookupResponse::new, (Executor)this.threadPool.executor("search")));
            }
        }
    }

    private void failIfSkipUnavailableFalse(Exception e, boolean skipOnFailure, ActionListener<LookupResponse> lookupListener) {
        if (ExceptionsHelper.isRemoteUnavailableException((Exception)e) && skipOnFailure) {
            lookupListener.onResponse((Object)new LookupResponse(e));
        } else {
            lookupListener.onFailure(e);
        }
    }

    protected Map<String, EnrichPolicy> availablePolicies() {
        return ((EnrichMetadata)this.projectResolver.getProjectMetadata(this.clusterService.state()).custom("enrich", (Metadata.ProjectCustom)EnrichMetadata.EMPTY)).getPolicies();
    }

    protected void getRemoteConnection(String cluster, boolean ensureConnected, ActionListener<Transport.Connection> listener) {
        this.remoteClusterService.maybeEnsureConnectedAndGetConnection(cluster, ensureConnected, listener);
    }

    private class RequestHandler
    implements TransportRequestHandler<LookupRequest> {
        private RequestHandler() {
        }

        public void messageReceived(LookupRequest request, TransportChannel channel, Task task) {
            Map<String, EnrichPolicy> availablePolicies = EnrichPolicyResolver.this.availablePolicies();
            ConcurrentMap failures = ConcurrentCollections.newConcurrentMap();
            ConcurrentMap resolvedPolices = ConcurrentCollections.newConcurrentMap();
            ThreadContext threadContext = EnrichPolicyResolver.this.threadPool.getThreadContext();
            ContextPreservingActionListener listener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)new ChannelActionListener(channel), (ThreadContext)threadContext);
            try (RefCountingListener refs = new RefCountingListener(listener.map(unused -> new LookupResponse(resolvedPolices, failures)));){
                for (String policyName : request.policyNames) {
                    EnrichPolicy p = availablePolicies.get(policyName);
                    if (p == null) continue;
                    ThreadContext.StoredContext ignored = threadContext.stashWithOrigin("enrich");
                    try {
                        String indexName = EnrichPolicy.getBaseName((String)policyName);
                        EnrichPolicyResolver.this.indexResolver.resolveIndices(indexName, IndexResolver.ALL_FIELDS, (ActionListener<IndexResolution>)refs.acquire(indexResult -> {
                            if (indexResult.isValid() && indexResult.get().concreteQualifiedIndices().size() == 1) {
                                EsIndex esIndex = indexResult.get();
                                Map<String, String> concreteIndices = Map.of(request.clusterAlias, (String)Iterables.get(esIndex.concreteQualifiedIndices(), (int)0));
                                ResolvedEnrichPolicy resolved = new ResolvedEnrichPolicy(p.getMatchField(), p.getType(), p.getEnrichFields(), concreteIndices, esIndex.mapping());
                                resolvedPolices.put(policyName, resolved);
                            } else {
                                failures.put(policyName, indexResult.toString());
                            }
                        }));
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
            }
        }
    }

    public record UnresolvedPolicy(String name, Enrich.Mode mode) {
        public static UnresolvedPolicy from(Enrich e) {
            return new UnresolvedPolicy(Foldables.stringLiteralValueOf(e.policyName(), "Enrich policy must be a constant string"), e.mode());
        }
    }

    private static class LookupResponse
    extends TransportResponse {
        final Map<String, ResolvedEnrichPolicy> policies;
        final Map<String, String> failures;
        final transient Exception connectionError;

        LookupResponse(Map<String, ResolvedEnrichPolicy> policies, Map<String, String> failures) {
            this.policies = policies;
            this.failures = failures;
            this.connectionError = null;
        }

        LookupResponse(Exception connectionError) {
            this.policies = Collections.emptyMap();
            this.failures = Collections.emptyMap();
            this.connectionError = connectionError;
        }

        LookupResponse(StreamInput in) throws IOException {
            PlanStreamInput planIn = new PlanStreamInput(in, in.namedWriteableRegistry(), null);
            this.policies = planIn.readMap(StreamInput::readString, ResolvedEnrichPolicy::new);
            this.failures = planIn.readMap(StreamInput::readString, StreamInput::readString);
            this.connectionError = null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            PlanStreamOutput pso = new PlanStreamOutput(out, null);
            pso.writeMap(this.policies, StreamOutput::writeWriteable);
            pso.writeMap(this.failures, StreamOutput::writeString);
        }
    }

    private static class LookupRequest
    extends AbstractTransportRequest {
        private final String clusterAlias;
        private final Collection<String> policyNames;

        LookupRequest(String clusterAlias, Collection<String> policyNames) {
            this.clusterAlias = clusterAlias;
            this.policyNames = policyNames;
        }

        LookupRequest(StreamInput in) throws IOException {
            this.clusterAlias = in.readString();
            this.policyNames = in.readStringCollectionAsList();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterAlias);
            out.writeStringCollection(this.policyNames);
        }
    }
}

