/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.Elasticsearch;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.entitlement.bootstrap.TestEntitlementBootstrap;
import org.elasticsearch.jdk.JarHell;

public class BootstrapForTesting {
    public static void ensureInitialized() {
    }

    static {
        Path javaTmpDir = PathUtils.get((String)Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "please set ${java.io.tmpdir} in pom.xml"), (String[])new String[0]);
        try {
            Files.createDirectories(javaTmpDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to create test temp directory", e);
        }
        boolean memoryLock = (Boolean)BootstrapSettings.MEMORY_LOCK_SETTING.get(Settings.EMPTY);
        boolean systemCallFilter = Booleans.parseBoolean((String)System.getProperty("tests.system_call_filter", "true"));
        Elasticsearch.initializeNatives((Path)javaTmpDir, (boolean)memoryLock, (boolean)systemCallFilter, (boolean)true);
        Elasticsearch.initializeProbes();
        BootstrapInfo.getSystemProperties();
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (Exception e) {
            throw new RuntimeException("found jar hell in test classpath", e);
        }
        IfConfig.logIfNecessary();
        try {
            TestEntitlementBootstrap.bootstrap(javaTmpDir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getClass().getSimpleName() + " while initializing entitlements for tests", e);
        }
    }
}

