/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic;

import java.math.BigInteger;
import java.util.function.BiFunction;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;

public final class Arithmetics {
    private Arithmetics() {
    }

    public static Number add(Number l, Number r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Double || r instanceof Double) {
            return l.doubleValue() + r.doubleValue();
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.valueOf(l.floatValue() + r.floatValue());
        }
        if (l instanceof BigInteger || r instanceof BigInteger) {
            BigInteger bi = Arithmetics.asBigInteger(l).add(Arithmetics.asBigInteger(r));
            return NumericUtils.asUnsignedLong(bi);
        }
        if (l instanceof Long || r instanceof Long) {
            return Math.addExact(l.longValue(), r.longValue());
        }
        return Math.addExact(l.intValue(), r.intValue());
    }

    public static Number sub(Number l, Number r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Double || r instanceof Double) {
            return l.doubleValue() - r.doubleValue();
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.valueOf(l.floatValue() - r.floatValue());
        }
        if (l instanceof BigInteger || r instanceof BigInteger) {
            BigInteger bi = Arithmetics.asBigInteger(l).subtract(Arithmetics.asBigInteger(r));
            return NumericUtils.asUnsignedLong(bi);
        }
        if (l instanceof Long || r instanceof Long) {
            return Math.subtractExact(l.longValue(), r.longValue());
        }
        return Math.subtractExact(l.intValue(), r.intValue());
    }

    public static Number mul(Number l, Number r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Double || r instanceof Double) {
            return l.doubleValue() * r.doubleValue();
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.valueOf(l.floatValue() * r.floatValue());
        }
        if (l instanceof BigInteger || r instanceof BigInteger) {
            BigInteger bi = Arithmetics.asBigInteger(l).multiply(Arithmetics.asBigInteger(r));
            return NumericUtils.asUnsignedLong(bi);
        }
        if (l instanceof Long || r instanceof Long) {
            return Math.multiplyExact(l.longValue(), r.longValue());
        }
        return Math.multiplyExact(l.intValue(), r.intValue());
    }

    public static Number div(Number l, Number r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Double || r instanceof Double) {
            return l.doubleValue() / r.doubleValue();
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.valueOf(l.floatValue() / r.floatValue());
        }
        if (l instanceof BigInteger || r instanceof BigInteger) {
            BigInteger bi = Arithmetics.asBigInteger(l).divide(Arithmetics.asBigInteger(r));
            return NumericUtils.asUnsignedLong(bi);
        }
        if (l instanceof Long || r instanceof Long) {
            return l.longValue() / r.longValue();
        }
        return l.intValue() / r.intValue();
    }

    public static Number mod(Number l, Number r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Double || r instanceof Double) {
            return l.doubleValue() % r.doubleValue();
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.valueOf(l.floatValue() % r.floatValue());
        }
        if (l instanceof BigInteger || r instanceof BigInteger) {
            BigInteger bi = Arithmetics.asBigInteger(l).remainder(Arithmetics.asBigInteger(r));
            return NumericUtils.asUnsignedLong(bi);
        }
        if (l instanceof Long || r instanceof Long) {
            return l.longValue() % r.longValue();
        }
        return l.intValue() % r.intValue();
    }

    public static Number negate(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            double d = n.doubleValue();
            if (d == Double.MIN_VALUE) {
                throw new ArithmeticException("double overflow");
            }
            return -n.doubleValue();
        }
        if (n instanceof Float) {
            float f = n.floatValue();
            if (f == Float.MIN_VALUE) {
                throw new ArithmeticException("float overflow");
            }
            return Float.valueOf(-n.floatValue());
        }
        if (n instanceof BigInteger) {
            if (((BigInteger)n).signum() != 0) {
                throw new ArithmeticException("unsigned_long overflow");
            }
            return n;
        }
        if (n instanceof Long) {
            return Math.negateExact(n.longValue());
        }
        return Math.negateExact(n.intValue());
    }

    public static BigInteger asBigInteger(Number n) {
        return n instanceof BigInteger ? (BigInteger)n : BigInteger.valueOf(n.longValue());
    }

    public static interface NumericArithmetic
    extends BiFunction<Number, Number, Number> {
        default public Object wrap(Object l, Object r) {
            if (!(l instanceof Number)) {
                throw new QlIllegalArgumentException("A number is required; received {}", l);
            }
            if (!(r instanceof Number)) {
                throw new QlIllegalArgumentException("A number is required; received {}", r);
            }
            return this.apply((Number)l, (Number)r);
        }
    }
}

