/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;

public record StoredFieldsSpec(boolean requiresSource, boolean requiresMetadata, Set<String> requiredStoredFields, IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat, Set<String> sourcePaths) {
    private final Set<String> requiredStoredFields;
    public static final StoredFieldsSpec NO_REQUIREMENTS = new StoredFieldsSpec(false, false, Set.of());
    public static final StoredFieldsSpec NEEDS_SOURCE = new StoredFieldsSpec(true, false, Set.of());

    public StoredFieldsSpec(boolean requiresSource, boolean requiresMetadata, Set<String> requiredStoredFields) {
        this(requiresSource, requiresMetadata, requiredStoredFields, IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE, Set.of());
    }

    public boolean noRequirements() {
        return !this.requiresSource && !this.requiresMetadata && this.requiredStoredFields.isEmpty() && this.sourcePaths.isEmpty();
    }

    public boolean onlyRequiresSourcePaths() {
        return this.requiresSource && !this.requiresMetadata && this.requiredStoredFields.isEmpty() && !this.sourcePaths.isEmpty();
    }

    public static StoredFieldsSpec withSourcePaths(IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat, Set<String> sourcePaths) {
        return new StoredFieldsSpec(true, false, Set.of(), ignoredSourceFormat, sourcePaths);
    }

    public StoredFieldsSpec merge(StoredFieldsSpec other) {
        IgnoredSourceFieldMapper.IgnoredSourceFormat mergedFormat;
        Set<String> mergedFields;
        if (this == other) {
            return this;
        }
        if (other.requiredStoredFields.isEmpty()) {
            mergedFields = this.requiredStoredFields;
        } else {
            mergedFields = new HashSet<String>(this.requiredStoredFields);
            mergedFields.addAll(other.requiredStoredFields);
        }
        Set<String> mergedSourcePaths = this.mergeSourcePaths(other);
        if (this.ignoredSourceFormat == IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE) {
            mergedFormat = other.ignoredSourceFormat;
        } else if (other.ignoredSourceFormat == IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE) {
            mergedFormat = this.ignoredSourceFormat;
        } else {
            if (this.ignoredSourceFormat != other.ignoredSourceFormat) {
                throw new IllegalStateException("failed to merge IgnoredFieldsSpec with differing formats [" + this.ignoredSourceFormat.name() + "," + other.ignoredSourceFormat.name() + "]");
            }
            mergedFormat = this.ignoredSourceFormat;
        }
        return new StoredFieldsSpec(this.requiresSource || other.requiresSource, this.requiresMetadata || other.requiresMetadata, mergedFields, mergedFormat, mergedSourcePaths);
    }

    private Set<String> mergeSourcePaths(StoredFieldsSpec other) {
        Set<Object> mergedSourcePaths;
        if (!this.sourcePaths.isEmpty() && !other.sourcePaths.isEmpty()) {
            mergedSourcePaths = new HashSet<String>(this.sourcePaths);
            mergedSourcePaths.addAll(other.sourcePaths);
        } else {
            mergedSourcePaths = !this.sourcePaths.isEmpty() ? (other.requiresSource ? Set.of() : this.sourcePaths) : (!other.sourcePaths.isEmpty() ? (this.requiresSource ? Set.of() : other.sourcePaths) : Set.of());
        }
        return mergedSourcePaths;
    }

    public Set<String> requiredStoredFields() {
        if (this.sourcePaths.isEmpty() || this.ignoredSourceFormat == IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE) {
            return this.requiredStoredFields;
        }
        if (this.requiredStoredFields.isEmpty()) {
            return Set.of("_ignored_source");
        }
        HashSet<String> mergedFields = new HashSet<String>(this.requiredStoredFields);
        mergedFields.add("_ignored_source");
        return mergedFields;
    }

    public static <T> StoredFieldsSpec build(Collection<T> sources, Function<T, StoredFieldsSpec> converter) {
        StoredFieldsSpec storedFieldsSpec = NO_REQUIREMENTS;
        for (T source : sources) {
            storedFieldsSpec = storedFieldsSpec.merge(converter.apply(source));
        }
        return storedFieldsSpec;
    }
}

