/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.diversification;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.vectors.VectorData;

public abstract class ResultDiversificationContext {
    private final String field;
    private final int size;
    private final VectorData queryVector;
    private Map<Integer, VectorData> fieldVectors = null;

    protected ResultDiversificationContext(String field, int size, @Nullable VectorData queryVector) {
        this.field = field;
        this.size = size;
        this.queryVector = queryVector;
    }

    public String getField() {
        return this.field;
    }

    public int getSize() {
        return this.size;
    }

    public void setFieldVectors(Map<Integer, VectorData> fieldVectors) {
        this.fieldVectors = fieldVectors;
    }

    public VectorData getQueryVector() {
        return this.queryVector;
    }

    public VectorData getFieldVector(int rank) {
        return this.fieldVectors.getOrDefault(rank, null);
    }

    public Set<Map.Entry<Integer, VectorData>> getFieldVectorsEntrySet() {
        return this.fieldVectors.entrySet();
    }
}

