/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongConsumer;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramBucket;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class InternalDateHistogram
extends InternalMultiBucketAggregation<InternalDateHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final BucketOrder order;
    private final DocValueFormat format;
    private final boolean keyed;
    private final boolean downsampledResultsOffset;
    private final long minDocCount;
    private final long offset;
    final EmptyBucketInfo emptyBucketInfo;

    InternalDateHistogram(String name, List<Bucket> buckets, BucketOrder order, long minDocCount, long offset, EmptyBucketInfo emptyBucketInfo, DocValueFormat formatter, boolean keyed, boolean downsampledResultsOffset, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.order = order;
        this.offset = offset;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.keyed = keyed;
        this.downsampledResultsOffset = downsampledResultsOffset;
    }

    boolean versionSupportsDownsamplingTimezone(TransportVersion version) {
        return version.onOrAfter(TransportVersions.V_8_13_0) || version.isPatchFrom(TransportVersions.V_8_12_1);
    }

    public InternalDateHistogram(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder(in);
        this.minDocCount = in.readVLong();
        this.emptyBucketInfo = this.minDocCount == 0L ? new EmptyBucketInfo(in) : null;
        this.offset = in.readLong();
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        this.downsampledResultsOffset = this.versionSupportsDownsamplingTimezone(in.getTransportVersion()) ? in.readBoolean() : false;
        this.buckets = in.readCollectionAsList(stream -> Bucket.readFrom(stream, this.format));
        if (in.getTransportVersion().between(TransportVersions.V_8_13_0, TransportVersions.V_8_14_0)) {
            this.buckets.sort(Comparator.comparingLong(b -> b.key));
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo.writeTo(out);
        }
        out.writeLong(this.offset);
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        if (this.versionSupportsDownsamplingTimezone(out.getTransportVersion())) {
            out.writeBoolean(this.downsampledResultsOffset);
        }
        out.writeCollection(this.buckets);
    }

    @Override
    public String getWriteableName() {
        return "date_histogram";
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    long getMinDocCount() {
        return this.minDocCount;
    }

    long getOffset() {
        return this.offset;
    }

    BucketOrder getOrder() {
        return this.order;
    }

    @Override
    public InternalDateHistogram create(List<Bucket> buckets) {
        return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.downsampledResultsOffset, this.metadata);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, prototype.format, aggregations);
    }

    private List<Bucket> reduceBuckets(PriorityQueue<IteratorAndCurrent<Bucket>> pq, AggregationReduceContext reduceContext) {
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            double key = ((Bucket)((IteratorAndCurrent)pq.top()).current()).key;
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if ((double)((Bucket)top.current()).key != key) {
                    Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    this.maybeAddBucket(reduceContext, reducedBuckets, reduced);
                    currentBuckets.clear();
                    key = ((Bucket)top.current()).key;
                }
                currentBuckets.add((Bucket)top.current());
                if (top.hasNext()) {
                    top.next();
                    assert ((double)((Bucket)top.current()).key > key) : "shards must return data sorted by key";
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                this.maybeAddBucket(reduceContext, reducedBuckets, reduced);
            }
        }
        return reducedBuckets;
    }

    private void maybeAddBucket(AggregationReduceContext reduceContext, List<Bucket> reducedBuckets, Bucket reduced) {
        if (reduced.getDocCount() >= this.minDocCount || !reduceContext.isFinalReduce()) {
            reduceContext.consumeBucketsAndMaybeBreak(1);
            reducedBuckets.add(reduced);
        } else {
            reduceContext.consumeBucketsAndMaybeBreak(-InternalDateHistogram.countInnerBucket(reduced));
        }
    }

    private Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        try (BucketReducer<Bucket> reducer = new BucketReducer<Bucket>(buckets.get(0), context, buckets.size());){
            for (Bucket bucket : buckets) {
                reducer.accept(bucket);
            }
            Bucket bucket = this.createBucket(reducer.getProto().key, reducer.getDocCount(), reducer.getAggregations());
            return bucket;
        }
    }

    private void addEmptyBuckets(List<Bucket> list, final AggregationReduceContext reduceContext) {
        class Counter
        implements LongConsumer {
            private int size;

            Counter() {
            }

            @Override
            public void accept(long key) {
                ++this.size;
                if (this.size >= 10000) {
                    reduceContext.consumeBucketsAndMaybeBreak(this.size);
                    this.size = 0;
                }
            }
        }
        Counter counter = new Counter();
        this.iterateEmptyBuckets(list, list.listIterator(), counter);
        reduceContext.consumeBucketsAndMaybeBreak(counter.size);
        final InternalAggregations reducedEmptySubAggs = InternalAggregations.reduce(this.emptyBucketInfo.subAggregations, reduceContext);
        final ListIterator<Bucket> iter = list.listIterator();
        this.iterateEmptyBuckets(list, iter, new LongConsumer(){
            private int size = 0;

            @Override
            public void accept(long key) {
                ++this.size;
                if (this.size >= 10000) {
                    reduceContext.consumeBucketsAndMaybeBreak(this.size);
                    this.size = 0;
                }
                iter.add(new Bucket(key, 0L, InternalDateHistogram.this.format, reducedEmptySubAggs));
            }
        });
    }

    private void iterateEmptyBuckets(List<Bucket> list, ListIterator<Bucket> iter, LongConsumer onBucket) {
        long max;
        long key;
        LongBounds bounds = this.emptyBucketInfo.bounds;
        Rounding.Prepared prepared = null;
        if (bounds != null && !list.isEmpty()) {
            long min = bounds.getMin() != null ? Math.min(bounds.getMin() + this.offset, list.get((int)0).key) : list.get((int)0).key;
            long max2 = bounds.getMax() != null ? Math.max(bounds.getMax() + this.offset, list.get((int)(list.size() - 1)).key) : list.get((int)(list.size() - 1)).key;
            prepared = this.createPrepared(min, max2);
        } else if (bounds != null && bounds.getMin() != null && bounds.getMax() != null) {
            prepared = this.createPrepared(bounds.getMin() + this.offset, bounds.getMax() + this.offset);
        } else if (!list.isEmpty()) {
            prepared = this.createPrepared(list.get((int)0).key, list.get((int)(list.size() - 1)).key);
        }
        if (bounds != null) {
            Bucket firstBucket;
            Bucket bucket = firstBucket = iter.hasNext() ? list.get(iter.nextIndex()) : null;
            if (firstBucket == null) {
                if (bounds.getMin() != null && bounds.getMax() != null) {
                    key = bounds.getMin() + this.offset;
                    max = bounds.getMax() + this.offset;
                    while (key <= max) {
                        onBucket.accept(key);
                        key = this.nextKey(prepared, key);
                    }
                }
            } else if (bounds.getMin() != null && (key = bounds.getMin() + this.offset) < firstBucket.key) {
                while (key < firstBucket.key) {
                    onBucket.accept(key);
                    key = this.nextKey(prepared, key);
                }
            }
        }
        Bucket lastBucket = null;
        while (iter.hasNext()) {
            Bucket nextBucket = list.get(iter.nextIndex());
            if (lastBucket != null) {
                long key2 = this.nextKey(prepared, lastBucket.key);
                while (key2 < nextBucket.key) {
                    onBucket.accept(key2);
                    key2 = this.nextKey(prepared, key2);
                }
                assert (key2 == nextBucket.key) : "key: " + key2 + ", nextBucket.key: " + nextBucket.key;
            }
            lastBucket = iter.next();
        }
        if (bounds != null && lastBucket != null && bounds.getMax() != null && bounds.getMax() + this.offset > lastBucket.key) {
            key = this.nextKey(prepared, lastBucket.key);
            max = bounds.getMax() + this.offset;
            while (key <= max) {
                onBucket.accept(key);
                key = this.nextKey(prepared, key);
            }
        }
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            private final PriorityQueue<IteratorAndCurrent<Bucket>> pq;
            {
                this.pq = new PriorityQueue<IteratorAndCurrent<Bucket>>(this, size){

                    protected boolean lessThan(IteratorAndCurrent<Bucket> a, IteratorAndCurrent<Bucket> b) {
                        return a.current().key < b.current().key;
                    }
                };
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalDateHistogram histogram = (InternalDateHistogram)aggregation;
                if (!histogram.buckets.isEmpty()) {
                    this.pq.add(new IteratorAndCurrent<Bucket>(histogram.buckets.iterator()));
                }
            }

            @Override
            public InternalAggregation get() {
                List<Bucket> reducedBuckets = InternalDateHistogram.this.reduceBuckets(this.pq, reduceContext);
                if (reduceContext.isFinalReduce()) {
                    if (InternalDateHistogram.this.minDocCount == 0L) {
                        InternalDateHistogram.this.addEmptyBuckets(reducedBuckets, reduceContext);
                    }
                    if (InternalOrder.isKeyDesc(InternalDateHistogram.this.order)) {
                        Collections.reverse(reducedBuckets);
                    } else if (!InternalOrder.isKeyAsc(InternalDateHistogram.this.order)) {
                        CollectionUtil.introSort(reducedBuckets, InternalDateHistogram.this.order.comparator());
                    }
                }
                return new InternalDateHistogram(InternalDateHistogram.this.getName(), reducedBuckets, InternalDateHistogram.this.order, InternalDateHistogram.this.minDocCount, InternalDateHistogram.this.offset, InternalDateHistogram.this.emptyBucketInfo, InternalDateHistogram.this.format, InternalDateHistogram.this.keyed, InternalDateHistogram.this.downsampledResultsOffset, InternalDateHistogram.this.getMetadata());
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            buckets.add(bucket.finalizeSampling(samplingContext));
        }
        return new InternalDateHistogram(this.getName(), buckets, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.downsampledResultsOffset, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        if (this.downsampledResultsOffset) {
            builder.field("downsampled_results_offset", Boolean.TRUE);
        }
        return builder;
    }

    @Override
    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).key;
    }

    Rounding.Prepared createPrepared(long min, long max) {
        return this.emptyBucketInfo.rounding.prepare(min - this.offset, max - this.offset);
    }

    long nextKey(Rounding.Prepared prepared, long key) {
        return prepared.nextRoundingValue(key - this.offset) + this.offset;
    }

    @Override
    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalDateHistogram(this.name, buckets2, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.downsampledResultsOffset, this.getMetadata());
    }

    @Override
    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.longValue(), docCount, this.format, aggregations);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalDateHistogram that = (InternalDateHistogram)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.order, that.order) && Objects.equals(this.format, that.format) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.offset, that.offset) && Objects.equals(this.emptyBucketInfo, that.emptyBucketInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.order, this.format, this.keyed, this.minDocCount, this.offset, this.emptyBucketInfo);
    }

    static class EmptyBucketInfo {
        final Rounding rounding;
        final InternalAggregations subAggregations;
        final LongBounds bounds;

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations, LongBounds bounds) {
            this.rounding = rounding;
            this.subAggregations = subAggregations;
            this.bounds = bounds;
        }

        EmptyBucketInfo(StreamInput in) throws IOException {
            this.rounding = Rounding.read(in);
            this.subAggregations = InternalAggregations.readFrom(in);
            this.bounds = in.readOptionalWriteable(LongBounds::new);
        }

        void writeTo(StreamOutput out) throws IOException {
            this.rounding.writeTo(out);
            this.subAggregations.writeTo(out);
            out.writeOptionalWriteable(this.bounds);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyBucketInfo that = (EmptyBucketInfo)obj;
            return Objects.equals(this.rounding, that.rounding) && Objects.equals(this.bounds, that.bounds) && Objects.equals(this.subAggregations, that.subAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.rounding, this.bounds, this.subAggregations);
        }
    }

    public static class Bucket
    extends AbstractHistogramBucket
    implements KeyComparable<Bucket> {
        final long key;

        public Bucket(long key, long docCount, DocValueFormat format, InternalAggregations aggregations) {
            super(docCount, aggregations, format);
            this.key = key;
        }

        public static Bucket readFrom(StreamInput in, DocValueFormat format) throws IOException {
            return new Bucket(in.readLong(), in.readVLong(), format, InternalAggregations.readFrom(in));
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return this.key == that.key && this.docCount == that.docCount && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.key).toString();
        }

        @Override
        public Object getKey() {
            return Instant.ofEpochMilli(this.key).atZone(ZoneOffset.UTC);
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed) throws IOException {
            String keyAsString = this.format.format(this.key).toString();
            if (keyed) {
                builder.startObject(keyAsString);
            } else {
                builder.startObject();
            }
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        @Override
        public int compareKey(Bucket other) {
            return Long.compare(this.key, other.key);
        }

        Bucket finalizeSampling(SamplingContext samplingContext) {
            return new Bucket(this.key, samplingContext.scaleUp(this.docCount), this.format, InternalAggregations.finalizeSampling(this.aggregations, samplingContext));
        }
    }
}

