/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues.fn;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.Warnings;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class Utf8CodePointsFromOrdsBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    static final int LOW_CARDINALITY = 1024;
    private final Warnings warnings;
    private final String fieldName;

    public Utf8CodePointsFromOrdsBlockLoader(Warnings warnings, String fieldName) {
        this.fieldName = fieldName;
        this.warnings = warnings;
    }

    @Override
    public BlockLoader.IntBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.ints(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        SortedSetDocValues docValues = context.reader().getSortedSetDocValues(this.fieldName);
        if (docValues != null) {
            if (docValues.getValueCount() > 1024L) {
                return new ImmediateOrdinals(this.warnings, docValues);
            }
            SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)docValues);
            if (singleton != null) {
                return new Singleton(singleton);
            }
            return new SortedSet(this.warnings, docValues);
        }
        SortedDocValues singleton = context.reader().getSortedDocValues(this.fieldName);
        if (singleton != null) {
            if (singleton.getValueCount() > 1024) {
                return new ImmediateOrdinals(this.warnings, DocValues.singleton((SortedDocValues)singleton));
            }
            return new Singleton(singleton);
        }
        return new BlockLoader.ConstantNullsReader();
    }

    public String toString() {
        return "Utf8CodePointsFromOrds[" + this.fieldName + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] readOrds(SortedSetDocValues ordinals, Warnings warnings, BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
        int count = docs.count() - offset;
        long size = Utf8CodePointsFromOrdsBlockLoader.sizeOfArray(count);
        factory.adjustBreaker(size);
        int[] ords = null;
        try {
            ords = new int[docs.count() - offset];
            for (int i = offset; i < docs.count(); ++i) {
                int doc = docs.get(i);
                if (!ordinals.advanceExact(doc)) {
                    ords[i] = -1;
                    continue;
                }
                if (ordinals.docValueCount() != 1) {
                    Warnings.registerSingleValueWarning(warnings);
                    ords[i] = -1;
                    continue;
                }
                ords[i] = Math.toIntExact(ordinals.nextOrd());
            }
            int[] result = ords;
            ords = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (ords != null) {
                factory.adjustBreaker(-size);
            }
        }
    }

    private static BlockLoader.Block buildFromCache(BlockLoader.BlockFactory factory, int[] cache, int[] ords) {
        try (BlockLoader.IntBuilder builder = factory.ints(ords.length);){
            for (int ord : ords) {
                if (ord >= 0) {
                    builder.appendInt(cache[ord]);
                    continue;
                }
                builder.appendNull();
            }
            BlockLoader.Block block = builder.build();
            return block;
        }
    }

    private static long sizeOfArray(int count) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4L * (long)count));
    }

    private static class ImmediateOrdinals
    extends BlockDocValuesReader {
        private final Warnings warnings;
        private final SortedSetDocValues ordinals;

        ImmediateOrdinals(Warnings warnings, SortedSetDocValues ordinals) {
            this.ordinals = ordinals;
            this.warnings = warnings;
        }

        /*
         * Could not resolve type clashes
         * Loose catch block
         */
        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            Object object;
            BlockLoader.IntBuilder builder;
            int[] counts;
            int[] sortedOrds;
            int[] ords;
            block15: {
                if (docs.count() - offset == 1) {
                    return this.blockForSingleDoc(factory, docs.get(offset));
                }
                ords = Utf8CodePointsFromOrdsBlockLoader.readOrds(this.ordinals, this.warnings, factory, docs, offset);
                sortedOrds = null;
                counts = null;
                sortedOrds = this.sortedOrds(factory, ords);
                int compactedLength = this.compactSorted(sortedOrds);
                counts = this.counts(factory, sortedOrds, compactedLength);
                builder = factory.ints(ords.length);
                for (int ord : ords) {
                    if (ord >= 0) {
                        builder.appendInt(counts[Arrays.binarySearch(sortedOrds, 0, compactedLength, ord)]);
                        continue;
                    }
                    builder.appendNull();
                }
                object = builder.build();
                if (builder == null) break block15;
                builder.close();
            }
            factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf((int[])ords));
            if (sortedOrds != null) {
                factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf((int[])sortedOrds));
            }
            if (counts != null) {
                factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf((int[])counts));
            }
            return object;
            {
                catch (Throwable throwable) {
                    try {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf((int[])ords));
                        if (sortedOrds != null) {
                            factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf((int[])sortedOrds));
                        }
                        if (counts != null) {
                            factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf(counts));
                        }
                        throw throwable3;
                    }
                }
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.IntBuilder)builder);
        }

        private void read(int docId, BlockLoader.IntBuilder builder) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                builder.appendNull();
                return;
            }
            if (this.ordinals.docValueCount() != 1) {
                Warnings.registerSingleValueWarning(this.warnings);
                builder.appendNull();
                return;
            }
            builder.appendInt(this.codePointsAtOrd(this.ordinals.nextOrd()));
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "Utf8CodePointsFromOrds.Immediate";
        }

        private BlockLoader.Block blockForSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                return factory.constantNulls(1);
            }
            if (this.ordinals.docValueCount() == 1) {
                return factory.constantInt(this.codePointsAtOrd(this.ordinals.nextOrd()), 1);
            }
            Warnings.registerSingleValueWarning(this.warnings);
            return factory.constantNulls(1);
        }

        private int[] sortedOrds(BlockLoader.BlockFactory factory, int[] ords) {
            factory.adjustBreaker(RamUsageEstimator.sizeOf((int[])ords));
            int[] sortedOrds = (int[])ords.clone();
            Arrays.sort(sortedOrds);
            return sortedOrds;
        }

        private int compactSorted(int[] sortedOrds) {
            int i;
            int c = 0;
            for (i = 0; i < sortedOrds.length && sortedOrds[i] < 0; ++i) {
            }
            while (i < sortedOrds.length) {
                if (!(i > 0 && sortedOrds[i - 1] == sortedOrds[i])) {
                    sortedOrds[c++] = sortedOrds[i];
                }
                ++i;
            }
            return c;
        }

        private int[] counts(BlockLoader.BlockFactory factory, int[] compactedSortedOrds, int compactedLength) throws IOException {
            long size = Utf8CodePointsFromOrdsBlockLoader.sizeOfArray(compactedLength);
            factory.adjustBreaker(size);
            int[] counts = new int[compactedLength];
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = this.codePointsAtOrd(compactedSortedOrds[i]);
            }
            return counts;
        }

        private int codePointsAtOrd(long ord) throws IOException {
            return UnicodeUtil.codePointCount((BytesRef)this.ordinals.lookupOrd(ord));
        }
    }

    private static class Singleton
    extends BlockDocValuesReader {
        private final SortedDocValues ordinals;
        private final int[] cache;
        private int cacheEntriesFilled;

        Singleton(SortedDocValues ordinals) {
            this.ordinals = ordinals;
            this.cache = new int[ordinals.getValueCount()];
            Arrays.fill(this.cache, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            if (docs.count() - offset == 1) {
                return this.blockForSingleDoc(factory, docs.get(offset));
            }
            if (this.cacheEntriesFilled == this.cache.length) {
                return this.buildFromFilledCache(factory, docs, offset);
            }
            int[] ords = this.readOrds(factory, docs, offset);
            try {
                this.fillCache(factory, ords);
                BlockLoader.Block block = Utf8CodePointsFromOrdsBlockLoader.buildFromCache(factory, this.cache, ords);
                return block;
            }
            finally {
                factory.adjustBreaker(-RamUsageEstimator.sizeOf((int[])ords));
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                ((BlockLoader.IntBuilder)builder).appendInt(this.codePointsAtOrd(this.ordinals.ordValue()));
            } else {
                builder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "Utf8CodePointsFromOrds.Singleton";
        }

        private BlockLoader.Block blockForSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                return factory.constantInt(this.codePointsAtOrd(this.ordinals.ordValue()), 1);
            }
            return factory.constantNulls(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[] readOrds(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            int count = docs.count() - offset;
            long size = Utf8CodePointsFromOrdsBlockLoader.sizeOfArray(count);
            factory.adjustBreaker(size);
            int[] ords = null;
            try {
                ords = new int[count];
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    ords[i] = !this.ordinals.advanceExact(doc) ? -1 : this.ordinals.ordValue();
                }
                int[] result = ords;
                ords = null;
                int[] nArray = result;
                return nArray;
            }
            finally {
                if (ords != null) {
                    factory.adjustBreaker(-size);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillCache(BlockLoader.BlockFactory factory, int[] ords) throws IOException {
            factory.adjustBreaker(RamUsageEstimator.sizeOf((int[])ords));
            try {
                int i;
                int[] sortedOrds = (int[])ords.clone();
                Arrays.sort(sortedOrds);
                for (i = 0; i < sortedOrds.length && sortedOrds[i] < 0; ++i) {
                }
                while (i < sortedOrds.length) {
                    this.codePointsAtOrd(sortedOrds[i++]);
                }
            }
            finally {
                factory.adjustBreaker(-RamUsageEstimator.sizeOf((int[])ords));
            }
        }

        private BlockLoader.Block buildFromFilledCache(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            int count = docs.count() - offset;
            try (BlockLoader.IntBuilder builder = factory.ints(count);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (!this.ordinals.advanceExact(doc)) {
                        builder.appendNull();
                        continue;
                    }
                    builder.appendInt(this.cache[this.ordinals.ordValue()]);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        private int codePointsAtOrd(int ord) throws IOException {
            int count;
            if (this.cache[ord] >= 0) {
                return this.cache[ord];
            }
            BytesRef v = this.ordinals.lookupOrd(ord);
            this.cache[ord] = count = UnicodeUtil.codePointCount((BytesRef)v);
            ++this.cacheEntriesFilled;
            return count;
        }
    }

    private static class SortedSet
    extends BlockDocValuesReader {
        private final Warnings warnings;
        private final SortedSetDocValues ordinals;
        private final int[] cache;
        private int cacheEntriesFilled;

        SortedSet(Warnings warnings, SortedSetDocValues ordinals) {
            this.warnings = warnings;
            this.ordinals = ordinals;
            this.cache = new int[Math.toIntExact(ordinals.getValueCount())];
            Arrays.fill(this.cache, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            if (docs.count() - offset == 1) {
                return this.blockForSingleDoc(factory, docs.get(offset));
            }
            if (this.cacheEntriesFilled == this.cache.length) {
                return this.buildFromFilledCache(factory, docs, offset);
            }
            int[] ords = Utf8CodePointsFromOrdsBlockLoader.readOrds(this.ordinals, this.warnings, factory, docs, offset);
            try {
                this.fillCache(factory, ords);
                BlockLoader.Block block = Utf8CodePointsFromOrdsBlockLoader.buildFromCache(factory, this.cache, ords);
                return block;
            }
            finally {
                factory.adjustBreaker(-RamUsageEstimator.shallowSizeOf((int[])ords));
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                builder.appendNull();
                return;
            }
            if (this.ordinals.docValueCount() != 1) {
                Warnings.registerSingleValueWarning(this.warnings);
                builder.appendNull();
                return;
            }
            ((BlockLoader.IntBuilder)builder).appendInt(this.codePointsAtOrd(Math.toIntExact(this.ordinals.nextOrd())));
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "Utf8CodePointsFromOrds.SortedSet";
        }

        private BlockLoader.Block blockForSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                return factory.constantNulls(1);
            }
            if (this.ordinals.docValueCount() == 1) {
                return factory.constantInt(this.codePointsAtOrd(Math.toIntExact(this.ordinals.nextOrd())), 1);
            }
            Warnings.registerSingleValueWarning(this.warnings);
            return factory.constantNulls(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillCache(BlockLoader.BlockFactory factory, int[] ords) throws IOException {
            factory.adjustBreaker(RamUsageEstimator.sizeOf((int[])ords));
            try {
                int i;
                int[] sortedOrds = (int[])ords.clone();
                Arrays.sort(sortedOrds);
                for (i = 0; i < sortedOrds.length && sortedOrds[i] < 0; ++i) {
                }
                while (i < sortedOrds.length) {
                    this.codePointsAtOrd(sortedOrds[i++]);
                }
            }
            finally {
                factory.adjustBreaker(-RamUsageEstimator.sizeOf((int[])ords));
            }
        }

        private BlockLoader.Block buildFromFilledCache(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            int count = docs.count() - offset;
            try (BlockLoader.IntBuilder builder = factory.ints(count);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (!this.ordinals.advanceExact(doc)) {
                        builder.appendNull();
                        continue;
                    }
                    if (this.ordinals.docValueCount() != 1) {
                        Warnings.registerSingleValueWarning(this.warnings);
                        builder.appendNull();
                        continue;
                    }
                    builder.appendInt(this.cache[Math.toIntExact(this.ordinals.nextOrd())]);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        private int codePointsAtOrd(int ord) throws IOException {
            int count;
            if (this.cache[ord] >= 0) {
                return this.cache[ord];
            }
            BytesRef v = this.ordinals.lookupOrd((long)ord);
            this.cache[ord] = count = UnicodeUtil.codePointCount((BytesRef)v);
            ++this.cacheEntriesFilled;
            return count;
        }
    }
}

