/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.logstash.snmp.OidFieldMapper;
import org.snmp4j.smi.OID;

public class DefaultOidFieldMapper
implements OidFieldMapper {
    private final int oidRootSkip;
    private final int oidPathLength;

    public DefaultOidFieldMapper() {
        this(0, 0);
    }

    public DefaultOidFieldMapper(int oidRootSkip, int oidPathLength) {
        if (oidRootSkip != 0 && oidPathLength != 0) {
            throw new IllegalArgumentException("Specify either an oidRootSkip or oidPathLength");
        }
        if (oidRootSkip < 0) {
            throw new IllegalArgumentException("oidRootSkip must be positive number");
        }
        if (oidPathLength < 0) {
            throw new IllegalArgumentException("oidPathLength must be positive number");
        }
        this.oidRootSkip = oidRootSkip;
        this.oidPathLength = oidPathLength;
    }

    @Override
    public String map(OID oid, OidFieldMapper.ResolvedIdentifier[] resolvedOidIdentifiers) {
        int[] identifiers = oid.getValue();
        CharSequence[] mappedIdentifiers = identifiers.length == resolvedOidIdentifiers.length ? (String[])Arrays.stream(resolvedOidIdentifiers).map(this::getNameOrIdentifier).toArray(String[]::new) : this.mapPartiallyQualifiedOid(oid, resolvedOidIdentifiers);
        if (this.oidRootSkip > 0) {
            return Arrays.stream(mappedIdentifiers).skip(this.oidRootSkip).collect(Collectors.joining("."));
        }
        if (this.oidPathLength > 0 && this.oidPathLength < mappedIdentifiers.length) {
            return Arrays.stream(mappedIdentifiers).skip((long)mappedIdentifiers.length - (long)this.oidPathLength).collect(Collectors.joining("."));
        }
        return String.join((CharSequence)".", mappedIdentifiers);
    }

    private String[] mapPartiallyQualifiedOid(OID oid, OidFieldMapper.ResolvedIdentifier[] resolvedOidIdentifiers) {
        String[] mappedIdentifiers = new String[oid.size()];
        int resolvedOidUpperBound = resolvedOidIdentifiers.length - 1;
        for (int i = 0; i < oid.getValue().length; ++i) {
            mappedIdentifiers[i] = i > resolvedOidUpperBound ? String.valueOf(oid.get(i)) : this.getNameOrIdentifier(resolvedOidIdentifiers[i]);
        }
        return mappedIdentifiers;
    }

    private String getNameOrIdentifier(OidFieldMapper.ResolvedIdentifier resolvedIdentifier) {
        if (resolvedIdentifier.getData() != null) {
            return resolvedIdentifier.getData().getName();
        }
        return String.valueOf(resolvedIdentifier.getIdentifier());
    }
}

