/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionContext
implements XSLTStaticContext {
    private StyleElement element;
    private NamePool namePool;
    private NamespaceResolver namespaceResolver = null;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getNamePool();
    }

    @Override
    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    @Override
    public boolean isSchemaAware() {
        return this.element.isSchemaAware();
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public LocationMap getLocationMap() {
        return this.element.getCompilation().getLocationMap();
    }

    @Override
    public void issueWarning(String s, SourceLocator locator) {
        this.element.issueWarning(new XPathException(s, locator));
    }

    @Override
    public NamePool getNamePool() {
        return this.namePool;
    }

    @Override
    public String getSystemId() {
        return this.element.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    @Override
    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.element.getURIForPrefix(prefix, false);
        if (uri == null) {
            XPathException err = new XPathException("Undeclared namespace prefix " + Err.wrap(prefix));
            err.setErrorCode("XPST0081");
            err.setIsStaticError(true);
            throw err;
        }
        return uri;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = this.element.makeNamespaceContext();
        }
        return this.namespaceResolver;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return this.element.getCompilation().getStylesheetPackage().getDecimalFormatManager();
    }

    public int getFingerprint(String qname, boolean useDefault) throws XPathException {
        String[] parts;
        try {
            parts = NameChecker.getQNameParts(qname);
        }
        catch (QNameException err) {
            throw new XPathException(err.getMessage());
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            String uri = "";
            if (useDefault) {
                uri = this.getURIForPrefix(prefix);
            }
            return this.namePool.getFingerprint(uri, qname);
        }
        String uri = this.getURIForPrefix(prefix);
        return this.namePool.getFingerprint(uri, parts[1]);
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        SourceBinding xslVariableDeclaration = this.element.bindVariable(qName);
        if (xslVariableDeclaration == null) {
            AxisIterator catchers;
            StyleElement catcher;
            SymbolicName sn = new SymbolicName(206, qName);
            Component comp = this.element.getCompilation().getStylesheetPackage().getComponent(sn);
            if (comp != null && comp.getDeclaringPackage() != this.element.getContainingPackage()) {
                GlobalVariable var = (GlobalVariable)comp.getProcedure();
                GlobalVariableReference vref = new GlobalVariableReference(var);
                vref.setStaticType(var.getRequiredType(), null, 0);
                return vref;
            }
            if (this.getXPathLanguageLevel().equals(DecimalValue.THREE) && qName.hasURI("http://www.w3.org/2005/xqt-errors") && (catcher = (StyleElement)(catchers = this.element.iterateAxis((byte)1, new NameTest(1, 139, this.getNamePool()))).next()) != null) {
                for (StructuredQName errorVariable : StandardNames.errorVariables) {
                    if (!errorVariable.getLocalPart().equals(qName.getLocalPart())) continue;
                    VendorFunctionLibrary lib = this.getConfiguration().getVendorFunctionLibrary();
                    StructuredQName functionName = new StructuredQName("saxon", "http://saxon.sf.net/", "dynamic-error-info");
                    SymbolicName fsn = new SymbolicName(155, functionName, 1);
                    Expression[] args = new Expression[]{new StringLiteral(qName.getLocalPart(), (Container)this.element)};
                    return lib.bind(fsn, args, this, this.element);
                }
            }
            XPathException err = new XPathException("Variable " + qName.getDisplayName() + " has not been declared (or its declaration is not in scope)");
            err.setErrorCode("XPST0008");
            err.setIsStaticError(true);
            throw err;
        }
        if (xslVariableDeclaration.hasProperty(8192)) {
            return new SuppliedParameterReference(0);
        }
        VariableReference var = xslVariableDeclaration.hasProperty(2) ? new GlobalVariableReference() : new LocalVariableReference();
        xslVariableDeclaration.registerReference(var);
        return var;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.element.getContainingPackage().getFunctionLibrary();
    }

    @Override
    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = NameChecker.getQNameParts(qname);
            String uri = parts[0].length() == 0 ? this.getDefaultElementNamespace() : this.getURIForPrefix(parts[0]);
            return this.element.getCompilation().getStyleNodeFactory(true).isElementAvailable(uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }

    @Override
    public StringCollator getCollation(String name) {
        if (name == null) {
            name = this.getDefaultCollationName();
        }
        try {
            return this.getConfiguration().getCollation(name);
        }
        catch (XPathException e) {
            this.issueWarning(e.getMessage(), this.getStyleElement());
            return null;
        }
    }

    @Override
    public String getDefaultCollationName() {
        return this.element.getDefaultCollationName();
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.element.xPath10ModeIsEnabled();
    }

    @Override
    public DecimalValue getXPathLanguageLevel() {
        return this.element.getCompilation().getPackageData().isAllowXPath30() ? DecimalValue.THREE : DecimalValue.TWO;
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.element.getContainingPackage().isImportedSchema(namespace);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.element.getContainingPackage().getImportedSchemaTable();
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        Configuration config = this.getConfiguration();
        if (type.getFingerprint() == 565) {
            return config.getXsdVersion() == 11;
        }
        return type.isAllowedInBasicXSLT() || config.isLicensedFeature(8);
    }

    @Override
    public KeyManager getKeyManager() {
        return this.element.getCompilation().getStylesheetPackage().getKeyManager();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

