/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jruby.embed.IsolatedScriptingContainer;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.osgi.internal.BundleWiringOSGiClassLoaderAdapter;
import org.jruby.util.Loader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OSGiIsolatedScriptingContainer
extends IsolatedScriptingContainer {
    public OSGiIsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public OSGiIsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public OSGiIsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public OSGiIsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public OSGiIsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
    }

    private Bundle toBundle(String symbolicName) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Bundle bundle = null;
        for (Bundle b2 : context.getBundles()) {
            if (!b2.getSymbolicName().equals(symbolicName)) continue;
            bundle = b2;
            break;
        }
        if (bundle == null) {
            throw new RuntimeException("unknown bundle: " + symbolicName);
        }
        return bundle;
    }

    @Deprecated
    private String createUri(Bundle cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + cl);
        }
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }

    @Deprecated
    public void addBundleToLoadPath(Bundle bundle) {
        this.addLoadPath(this.createUri(bundle, "/.jrubydir"));
    }

    @Deprecated
    public void addBundleToLoadPath(String symbolicName) {
        this.addBundleToLoadPath(this.toBundle(symbolicName));
    }

    public void addBundle(String symbolicName) {
        this.addBundle(this.toBundle(symbolicName));
    }

    public void addBundle(Bundle bundle) {
        this.getProvider().getRubyInstanceConfig().addLoader(new BundleGetResources(bundle));
    }

    @Deprecated
    public void addBundleToGemPath(Bundle bundle) {
        this.addGemPath(this.createUri(bundle, "/specifications/.jrubydir"));
    }

    @Deprecated
    public void addBundleToGemPath(String symbolicName) {
        this.addBundleToGemPath(this.toBundle(symbolicName));
    }

    static class BundleGetResources
    implements Loader {
        private final Bundle bundle;

        BundleGetResources(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public URL getResource(String path2) {
            return this.bundle.getResource(path2);
        }

        @Override
        public Enumeration<URL> getResources(String path2) throws IOException {
            return this.bundle.getResources(path2);
        }

        @Override
        public Class<?> loadClass(String name2) throws ClassNotFoundException {
            return this.bundle.loadClass(name2);
        }

        @Override
        public ClassLoader getClassLoader() {
            return new BundleWiringOSGiClassLoaderAdapter().getClassLoader(this.bundle);
        }
    }
}

