/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public final class BulkUpdateApiKeyResponse
extends ActionResponse
implements ToXContentObject,
Writeable {
    private final List<String> updated;
    private final List<String> noops;
    private final Map<String, Exception> errorDetails;

    public BulkUpdateApiKeyResponse(List<String> updated, List<String> noops, Map<String, Exception> errorDetails) {
        this.updated = updated;
        this.noops = noops;
        this.errorDetails = errorDetails;
    }

    public BulkUpdateApiKeyResponse(StreamInput in) throws IOException {
        this.updated = in.readStringCollectionAsList();
        this.noops = in.readStringCollectionAsList();
        this.errorDetails = in.readMap(StreamInput::readException);
    }

    public List<String> getUpdated() {
        return this.updated;
    }

    public List<String> getNoops() {
        return this.noops;
    }

    public Map<String, Exception> getErrorDetails() {
        return this.errorDetails;
    }

    public int getTotalResultCount() {
        return this.updated.size() + this.noops.size() + this.errorDetails.size();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().stringListField("updated", this.updated).stringListField("noops", this.noops);
        XContentUtils.maybeAddErrorDetails(builder, this.errorDetails);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.updated);
        out.writeStringCollection(this.noops);
        out.writeMap(this.errorDetails, StreamOutput::writeException);
    }

    public String toString() {
        return "BulkUpdateApiKeyResponse{updated=" + String.valueOf(this.updated) + ", noops=" + String.valueOf(this.noops) + ", errorDetails=" + String.valueOf(this.errorDetails) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> updated = new ArrayList<String>();
        private final List<String> noops = new ArrayList<String>();
        private final Map<String, Exception> errorDetails = new HashMap<String, Exception>();

        public Builder updated(String id) {
            this.updated.add(id);
            return this;
        }

        public Builder noop(String id) {
            this.noops.add(id);
            return this;
        }

        public Builder error(String id, Exception ex) {
            this.errorDetails.put(id, ex);
            return this;
        }

        public BulkUpdateApiKeyResponse build() {
            return new BulkUpdateApiKeyResponse(this.updated, this.noops, this.errorDetails);
        }
    }
}

