/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class SamplingMetadata
implements Metadata.ProjectCustom {
    public static final TransportVersion SAMPLING_CONFIGURATION = TransportVersion.fromName("sampling_configuration");
    public static final String TYPE = "sampling";
    private static final String INDEX_SAMPLING_CONFIG_MAP_FIELD_NAME = "index_to_sampling_config";
    private static final ParseField INDEX_SAMPLING_CONFIG_MAP_PARSE_FIELD = new ParseField("index_to_sampling_config", new String[0]);
    private final Map<String, SamplingConfiguration> indexToSamplingConfigMap;
    private static final ConstructingObjectParser<SamplingMetadata, Void> PARSER = new ConstructingObjectParser("sampling", true, args -> {
        List indexToSamplingConfigs = (List)args[0];
        return new SamplingMetadata(indexToSamplingConfigs.stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
    });

    public SamplingMetadata(Map<String, SamplingConfiguration> indexToSamplingConfigMap) {
        this.indexToSamplingConfigMap = new HashMap<String, SamplingConfiguration>(indexToSamplingConfigMap);
    }

    public SamplingMetadata(StreamInput in) throws IOException {
        this.indexToSamplingConfigMap = in.readMap(StreamInput::readString, SamplingConfiguration::new);
    }

    public Map<String, SamplingConfiguration> getIndexToSamplingConfigMap() {
        return this.indexToSamplingConfigMap;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.indexToSamplingConfigMap, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public static SamplingMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamplingMetadata that = (SamplingMetadata)o;
        return this.indexToSamplingConfigMap.equals(that.indexToSamplingConfigMap);
    }

    public int hashCode() {
        return Objects.hash(this.indexToSamplingConfigMap);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.complementOf(EnumSet.of(Metadata.XContentContext.SNAPSHOT));
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return SAMPLING_CONFIGURATION;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.xContentObjectFields(INDEX_SAMPLING_CONFIG_MAP_PARSE_FIELD.getPreferredName(), this.indexToSamplingConfigMap);
    }

    @Override
    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom previousState) {
        return new SamplingMetadataDiff((SamplingMetadata)previousState, this);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput in) throws IOException {
        return new SamplingMetadataDiff(in);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, index) -> Tuple.tuple(index, SamplingConfiguration.fromXContent(p)), INDEX_SAMPLING_CONFIG_MAP_PARSE_FIELD);
    }

    static class SamplingMetadataDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        final Diff<Map<String, SamplingConfiguration>> indexToSamplingConfigMap;

        SamplingMetadataDiff(SamplingMetadata before, SamplingMetadata after) {
            this.indexToSamplingConfigMap = DiffableUtils.diff(before.indexToSamplingConfigMap, after.indexToSamplingConfigMap, DiffableUtils.getStringKeySerializer());
        }

        SamplingMetadataDiff(StreamInput in) throws IOException {
            this.indexToSamplingConfigMap = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), SamplingConfiguration::new, SamplingConfiguration::readDiffFrom);
        }

        @Override
        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            return new SamplingMetadata(this.indexToSamplingConfigMap.apply(((SamplingMetadata)part).indexToSamplingConfigMap));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.indexToSamplingConfigMap.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return SamplingMetadata.TYPE;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return SAMPLING_CONFIGURATION;
        }
    }
}

