/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.BufferingJsonParser;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.LookAheadJsonParser;
import co.elastic.clients.json.UnexpectedJsonEventException;
import co.elastic.clients.json.jackson.JacksonJsonBuffer;
import co.elastic.clients.json.jackson.JacksonJsonpLocation;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.json.jackson.JacksonUtils;
import co.elastic.clients.json.jackson.JsonValueParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public class JacksonJsonpParser
implements LookAheadJsonParser,
BufferingJsonParser {
    private final com.fasterxml.jackson.core.JsonParser parser;
    private final JacksonJsonpMapper mapper;
    private boolean hasNextWasCalled = false;
    private static final EnumMap<JsonToken, JsonParser.Event> tokenToEvent = new EnumMap(JsonToken.class);
    private JsonValueParser valueParser;

    public JacksonJsonpParser(com.fasterxml.jackson.core.JsonParser parser, JacksonJsonpMapper mapper) {
        this.parser = parser;
        this.mapper = mapper;
    }

    public com.fasterxml.jackson.core.JsonParser jacksonParser() {
        return this.parser;
    }

    private JsonParsingException convertException(IOException ioe) {
        return new JsonParsingException("Jackson exception: " + ioe.getMessage(), ioe, this.getLocation());
    }

    private JsonToken fetchNextToken() {
        try {
            return this.parser.nextToken();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    private void ensureTokenIsCurrent() {
        if (this.hasNextWasCalled) {
            throw new IllegalStateException("Cannot get event data as parser as already been moved to the next event");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextWasCalled) {
            return this.parser.currentToken() != null;
        }
        this.hasNextWasCalled = true;
        return this.fetchNextToken() != null;
    }

    @Override
    public JsonParser.Event next() {
        JsonToken token;
        if (this.hasNextWasCalled) {
            token = this.parser.getCurrentToken();
            this.hasNextWasCalled = false;
        } else {
            token = this.fetchNextToken();
        }
        if (token == null) {
            throw new NoSuchElementException();
        }
        JsonParser.Event result = tokenToEvent.get(token);
        if (result == null) {
            throw new JsonParsingException("Unsupported Jackson event type '" + token + "'", this.getLocation());
        }
        return result;
    }

    @Override
    public String getString() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getValueAsString();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public boolean isIntegralNumber() {
        this.ensureTokenIsCurrent();
        return this.parser.isExpectedNumberIntToken();
    }

    @Override
    public int getInt() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getIntValue();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public long getLong() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getLongValue();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getDecimalValue();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public JsonLocation getLocation() {
        return new JacksonJsonpLocation(this.parser.getCurrentLocation());
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public JsonObject getObject() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Unexpected event '" + this.parser.currentToken() + "' at " + this.parser.getTokenLocation());
        }
        if (this.valueParser == null) {
            this.valueParser = new JsonValueParser();
        }
        try {
            return this.valueParser.parseObject(this.parser);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public JsonArray getArray() {
        this.ensureTokenIsCurrent();
        if (this.valueParser == null) {
            this.valueParser = new JsonValueParser();
        }
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Unexpected event '" + this.parser.currentToken() + "' at " + this.parser.getTokenLocation());
        }
        try {
            return this.valueParser.parseArray(this.parser);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public JsonValue getValue() {
        this.ensureTokenIsCurrent();
        if (this.valueParser == null) {
            this.valueParser = new JsonValueParser();
        }
        try {
            return this.valueParser.parseValue(this.parser);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void skipObject() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_OBJECT) {
            return;
        }
        try {
            JsonToken token;
            int depth = 1;
            do {
                token = this.parser.nextToken();
                switch (token) {
                    case START_OBJECT: {
                        ++depth;
                        break;
                    }
                    case END_OBJECT: {
                        --depth;
                    }
                }
            } while (token != JsonToken.END_OBJECT || depth != 0);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void skipArray() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            return;
        }
        try {
            JsonToken token;
            int depth = 1;
            do {
                token = this.parser.nextToken();
                switch (token) {
                    case START_ARRAY: {
                        ++depth;
                        break;
                    }
                    case END_ARRAY: {
                        --depth;
                    }
                }
            } while (token != JsonToken.END_ARRAY || depth != 0);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.getObject().entrySet().stream();
    }

    @Override
    public Stream<JsonValue> getArrayStream() {
        return this.getArray().stream();
    }

    @Override
    public Stream<JsonValue> getValueStream() {
        return LookAheadJsonParser.super.getValueStream();
    }

    @Override
    public Map.Entry<String, JsonParser> lookAheadFieldValue(String name, String defaultValue) {
        TokenBuffer tb = new TokenBuffer(this.parser, null);
        try {
            tb.copyCurrentEvent(this.parser);
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                this.expectEvent(JsonToken.FIELD_NAME);
                String fieldName = this.parser.getCurrentName();
                if (fieldName.equals(name)) {
                    tb.copyCurrentEvent(this.parser);
                    String result = null;
                    switch (this.parser.nextToken()) {
                        case VALUE_STRING: {
                            result = this.parser.getText();
                            break;
                        }
                        case VALUE_TRUE: {
                            result = "true";
                            break;
                        }
                        case VALUE_FALSE: {
                            result = "false";
                            break;
                        }
                        default: {
                            this.expectEvent(JsonToken.VALUE_STRING);
                        }
                    }
                    tb.copyCurrentEvent(this.parser);
                    return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(result, new JacksonJsonpParser((com.fasterxml.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (com.fasterxml.jackson.core.JsonParser)tb.asParser(), (com.fasterxml.jackson.core.JsonParser)this.parser), this.mapper));
                }
                tb.copyCurrentStructure(this.parser);
            }
            tb.copyCurrentEvent(this.parser);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(defaultValue, new JacksonJsonpParser((com.fasterxml.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (com.fasterxml.jackson.core.JsonParser)tb.asParser(), (com.fasterxml.jackson.core.JsonParser)this.parser), this.mapper));
    }

    @Override
    public <Variant> Map.Entry<Variant, JsonParser> findVariant(Map<String, Variant> variants) {
        TokenBuffer tb = new TokenBuffer(this.parser, null);
        try {
            if (this.parser.currentToken() != JsonToken.START_OBJECT) {
                tb.copyCurrentStructure(this.parser);
            } else {
                tb.copyCurrentEvent(this.parser);
                while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                    this.expectEvent(JsonToken.FIELD_NAME);
                    String fieldName = this.parser.getCurrentName();
                    Variant variant = variants.get(fieldName);
                    if (variant != null) {
                        tb.copyCurrentEvent(this.parser);
                        return new AbstractMap.SimpleImmutableEntry<Variant, JacksonJsonpParser>(variant, new JacksonJsonpParser((com.fasterxml.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (com.fasterxml.jackson.core.JsonParser)tb.asParser(), (com.fasterxml.jackson.core.JsonParser)this.parser), this.mapper));
                    }
                    tb.copyCurrentStructure(this.parser);
                }
                tb.copyCurrentEvent(this.parser);
            }
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return new AbstractMap.SimpleImmutableEntry<Object, JacksonJsonpParser>(null, new JacksonJsonpParser((com.fasterxml.jackson.core.JsonParser)JsonParserSequence.createFlattened((boolean)false, (com.fasterxml.jackson.core.JsonParser)tb.asParser(), (com.fasterxml.jackson.core.JsonParser)this.parser), this.mapper));
    }

    private void expectNextEvent(JsonToken expected) throws IOException {
        JsonToken event = this.parser.nextToken();
        if (event != expected) {
            throw new UnexpectedJsonEventException((JsonParser)this, tokenToEvent.get(event), tokenToEvent.get(expected));
        }
    }

    private void expectEvent(JsonToken expected) {
        JsonToken event = this.parser.currentToken();
        if (event != expected) {
            throw new UnexpectedJsonEventException((JsonParser)this, tokenToEvent.get(event), tokenToEvent.get(expected));
        }
    }

    @Override
    public JsonData getJsonData() {
        try {
            TokenBuffer buffer = new TokenBuffer(this.parser);
            buffer.copyCurrentStructure(this.parser);
            return new JacksonJsonBuffer(buffer, this.mapper);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
    }

    static {
        tokenToEvent.put(JsonToken.END_ARRAY, JsonParser.Event.END_ARRAY);
        tokenToEvent.put(JsonToken.END_OBJECT, JsonParser.Event.END_OBJECT);
        tokenToEvent.put(JsonToken.FIELD_NAME, JsonParser.Event.KEY_NAME);
        tokenToEvent.put(JsonToken.START_ARRAY, JsonParser.Event.START_ARRAY);
        tokenToEvent.put(JsonToken.START_OBJECT, JsonParser.Event.START_OBJECT);
        tokenToEvent.put(JsonToken.VALUE_FALSE, JsonParser.Event.VALUE_FALSE);
        tokenToEvent.put(JsonToken.VALUE_NULL, JsonParser.Event.VALUE_NULL);
        tokenToEvent.put(JsonToken.VALUE_NUMBER_FLOAT, JsonParser.Event.VALUE_NUMBER);
        tokenToEvent.put(JsonToken.VALUE_NUMBER_INT, JsonParser.Event.VALUE_NUMBER);
        tokenToEvent.put(JsonToken.VALUE_STRING, JsonParser.Event.VALUE_STRING);
        tokenToEvent.put(JsonToken.VALUE_TRUE, JsonParser.Event.VALUE_TRUE);
    }
}

