/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScriptProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String id;
    @Nullable
    private final String lang;
    private final Map<String, JsonData> params;
    @Nullable
    private final String source;
    public static final JsonpDeserializer<ScriptProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptProcessor::setupScriptProcessorDeserializer);

    private ScriptProcessor(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.lang = builder.lang;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.source = builder.source;
    }

    public static ScriptProcessor of(Function<Builder, ObjectBuilder<ScriptProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Script;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String source() {
        return this.source;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
    }

    protected static void setupScriptProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptProcessor> {
        @Nullable
        private String id;
        @Nullable
        private String lang;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String source;

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptProcessor build() {
            this._checkSingleUse();
            return new ScriptProcessor(this);
        }
    }
}

