"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _esqlUtils = require("@kbn/esql-utils");
var _discoverUtils = require("@kbn/discover-utils");
var _common = require("@kbn/saved-search-plugin/common");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _common2 = require("../common");
var _locator = require("./application/context/services/locator");
var _locator2 = require("./application/doc/locator");
var _register_feature = require("./plugin_imports/register_feature");
var _initialize_kbn_url_tracking = require("./utils/initialize_kbn_url_tracking");
var _defaults = require("./customizations/defaults");
var _constants = require("./embeddable/constants");
var _discover_container = require("./components/discover_container");
var _search_provider = require("./plugin_imports/search_provider");
var _types = require("./context_awareness/types");
var _discover_ebt_manager_registrations = require("./ebt_manager/discover_ebt_manager_registrations");
var _forward_legacy_urls = require("./plugin_imports/forward_legacy_urls");
var _get_profiles_inspector_view = require("./context_awareness/inspector/get_profiles_inspector_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Contains Discover, one of the oldest parts of Kibana
 * Discover provides embeddables for Dashboards
 */
class DiscoverPlugin {
  constructor(initializerContext) {
    var _experimental$ruleFor, _experimental$enabled;
    (0, _defineProperty2.default)(this, "discoverEbtContext$", new _rxjs.BehaviorSubject({
      discoverProfiles: []
    }));
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    (0, _defineProperty2.default)(this, "scopedHistory", void 0);
    (0, _defineProperty2.default)(this, "urlTracker", void 0);
    (0, _defineProperty2.default)(this, "stopUrlTracking", void 0);
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "contextLocator", void 0);
    (0, _defineProperty2.default)(this, "singleDocLocator", void 0);
    (0, _defineProperty2.default)(this, "profileProviderSharedServices", void 0);
    (0, _defineProperty2.default)(this, "getDiscoverServices", async ({
      core,
      plugins,
      profilesManager,
      ebtManager,
      scopedHistory,
      setHeaderActionMenu
    }) => {
      const [{
        buildServices
      }, historyService] = await Promise.all([getSharedServices(), getHistoryService()]);
      return buildServices({
        core,
        plugins,
        context: this.initializerContext,
        locator: this.locator,
        contextLocator: this.contextLocator,
        singleDocLocator: this.singleDocLocator,
        history: historyService.getHistory(),
        scopedHistory,
        urlTracker: this.urlTracker,
        profilesManager,
        ebtManager,
        setHeaderActionMenu
      });
    });
    this.initializerContext = initializerContext;
    const experimental = this.initializerContext.config.get().experimental;
    this.experimentalFeatures = {
      ruleFormV2Enabled: (_experimental$ruleFor = experimental === null || experimental === void 0 ? void 0 : experimental.ruleFormV2Enabled) !== null && _experimental$ruleFor !== void 0 ? _experimental$ruleFor : false,
      enabledProfiles: (_experimental$enabled = experimental === null || experimental === void 0 ? void 0 : experimental.enabledProfiles) !== null && _experimental$enabled !== void 0 ? _experimental$enabled : []
    };
  }
  setup(core, plugins) {
    const baseUrl = core.http.basePath.prepend('/app/discover');
    if (plugins.share) {
      const useHash = core.uiSettings.get('state:storeInSessionStorage');
      this.locator = plugins.share.url.locators.create({
        id: _common2.DISCOVER_APP_LOCATOR,
        getLocation: async params => {
          const {
            appLocatorGetLocation
          } = await getLocators();
          return appLocatorGetLocation({
            useHash
          }, params);
        }
      });
      this.contextLocator = plugins.share.url.locators.create({
        id: _locator.DISCOVER_CONTEXT_APP_LOCATOR,
        getLocation: async params => {
          const {
            contextAppLocatorGetLocation
          } = await getLocators();
          return contextAppLocatorGetLocation({
            useHash
          }, params);
        }
      });
      this.singleDocLocator = plugins.share.url.locators.create({
        id: _locator2.DISCOVER_SINGLE_DOC_LOCATOR,
        getLocation: async params => {
          const {
            singleDocLocatorGetLocation
          } = await getLocators();
          return singleDocLocatorGetLocation(params);
        }
      });
    }
    if (plugins.globalSearch) {
      plugins.globalSearch.registerResultProvider((0, _search_provider.getESQLSearchProvider)({
        isESQLEnabled: core.uiSettings.get(_esqlUtils.ENABLE_ESQL),
        locator: this.locator,
        getServices: async () => {
          const [coreStart, startPlugins] = await core.getStartServices();
          return [coreStart, startPlugins];
        }
      }));
    }
    plugins.inspector.registerView((0, _get_profiles_inspector_view.getProfilesInspectorView)());
    const {
      setTrackedUrl,
      restorePreviousUrl,
      stopUrlTracker,
      appMounted,
      appUnMounted,
      setTrackingEnabled
    } = (0, _initialize_kbn_url_tracking.initializeKbnUrlTracking)({
      baseUrl,
      core,
      navLinkUpdater$: this.appStateUpdater,
      plugins,
      getScopedHistory: () => this.scopedHistory
    });
    this.urlTracker = {
      setTrackedUrl,
      restorePreviousUrl,
      setTrackingEnabled
    };
    this.stopUrlTracking = stopUrlTracker;
    const getEbtManager = (0, _lodash.once)(async () => {
      const {
        DiscoverEBTManager
      } = await getSharedServices();
      const ebtManager = new DiscoverEBTManager();
      ebtManager.initialize({
        core,
        discoverEbtContext$: this.discoverEbtContext$
      });
      return ebtManager;
    });
    (0, _discover_ebt_manager_registrations.registerDiscoverEBTManagerAnalytics)(core, this.discoverEbtContext$);
    core.application.register({
      id: _common2.PLUGIN_ID,
      title: 'Discover',
      updater$: this.appStateUpdater,
      order: 1000,
      euiIconType: 'logoKibana',
      defaultPath: '#/',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      visibleIn: ['globalSearch', 'sideNav', 'kibanaOverview'],
      mount: async params => {
        const [[coreStart, discoverStartPlugins], historyService, ebtManager, {
          renderApp
        }] = await Promise.all([core.getStartServices(), getHistoryService(), getEbtManager(), Promise.resolve().then(() => _interopRequireWildcard(require('./application')))]);

        // Store the current scoped history so initializeKbnUrlTracking can access it
        this.scopedHistory = params.history;
        historyService.syncHistoryLocations();
        appMounted();

        // dispatch synthetic hash change event to update hash history objects
        // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
        const unlistenParentHistory = this.scopedHistory.listen(() => {
          window.dispatchEvent(new HashChangeEvent('hashchange'));
        });
        ebtManager.onDiscoverAppMounted();
        const services = await this.getDiscoverServicesWithProfiles({
          core: coreStart,
          plugins: discoverStartPlugins,
          ebtManager,
          scopedHistory: this.scopedHistory,
          setHeaderActionMenu: params.setHeaderActionMenu
        });

        // make sure the data view list is up to date
        discoverStartPlugins.dataViews.clearCache();
        const unmount = renderApp({
          element: params.element,
          onAppLeave: params.onAppLeave,
          services,
          customizationContext: _defaults.defaultCustomizationContext
        });
        return () => {
          ebtManager.onDiscoverAppUnmounted();
          unlistenParentHistory();
          unmount();
          appUnMounted();
        };
      }
    });
    if (plugins.home) {
      (0, _register_feature.registerFeature)(plugins.home);
    }
    (0, _forward_legacy_urls.forwardLegacyUrls)(plugins.urlForwarding);
    this.registerEmbeddable(core, plugins);
    return {
      locator: this.locator
    };
  }
  start(core, plugins) {
    plugins.uiActions.addTriggerActionAsync('CONTEXT_MENU_TRIGGER', _constants.ACTION_VIEW_SAVED_SEARCH, async () => {
      const {
        ViewSavedSearchAction
      } = await getEmbeddableServices();
      return new ViewSavedSearchAction(core.application, this.locator);
    });
    plugins.uiActions.registerTrigger(_constants.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER);
    plugins.uiActions.registerTrigger(_types.DISCOVER_CELL_ACTIONS_TRIGGER);
    const isEsqlEnabled = core.uiSettings.get(_esqlUtils.ENABLE_ESQL);
    if (plugins.share && this.locator && isEsqlEnabled) {
      var _plugins$share;
      const discoverAppLocator = this.locator;
      (_plugins$share = plugins.share) === null || _plugins$share === void 0 ? void 0 : _plugins$share.url.locators.create({
        id: _deeplinksAnalytics.DISCOVER_ESQL_LOCATOR,
        getLocation: async () => {
          const {
            esqlLocatorGetLocation
          } = await getLocators();
          return esqlLocatorGetLocation({
            discoverAppLocator,
            dataViews: plugins.dataViews,
            http: core.http
          });
        }
      });
    }
    const getDiscoverServicesInternal = async () => {
      const [ebtManager, {
        profilesManager
      }] = await Promise.all([getEmptyEbtManager(), this.createProfileServices()]);
      return this.getDiscoverServices({
        core,
        plugins,
        profilesManager,
        ebtManager
      });
    };
    return {
      locator: this.locator,
      DiscoverContainer: props => /*#__PURE__*/_react.default.createElement(_discover_container.DiscoverContainerInternal, (0, _extends2.default)({
        getDiscoverServices: getDiscoverServicesInternal
      }, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 9
        }
      }))
    };
  }
  stop() {
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
  async createProfileServices() {
    const {
      RootProfileService,
      DataSourceProfileService,
      DocumentProfileService,
      ProfilesManager
    } = await getSharedServices();
    const rootProfileService = new RootProfileService();
    const dataSourceProfileService = new DataSourceProfileService();
    const documentProfileService = new DocumentProfileService();
    const profilesManager = new ProfilesManager(rootProfileService, dataSourceProfileService, documentProfileService);
    return {
      rootProfileService,
      dataSourceProfileService,
      documentProfileService,
      profilesManager
    };
  }
  async getDiscoverServicesWithProfiles({
    core,
    plugins,
    ebtManager,
    scopedHistory,
    setHeaderActionMenu
  }) {
    var _this$experimentalFea;
    const [{
      rootProfileService,
      dataSourceProfileService,
      documentProfileService,
      profilesManager
    }, {
      createProfileProviderSharedServices,
      registerProfileProviders
    }] = await Promise.all([this.createProfileServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./context_awareness/profile_providers')))]);
    const [sharedServices, services] = await Promise.all([this.profileProviderSharedServices ??= createProfileProviderSharedServices(plugins), this.getDiscoverServices({
      core,
      plugins,
      profilesManager,
      ebtManager,
      scopedHistory,
      setHeaderActionMenu
    })]);
    registerProfileProviders({
      rootProfileService,
      dataSourceProfileService,
      documentProfileService,
      enabledExperimentalProfileIds: (_this$experimentalFea = this.experimentalFeatures.enabledProfiles) !== null && _this$experimentalFea !== void 0 ? _this$experimentalFea : [],
      sharedServices,
      services
    });
    return services;
  }
  registerEmbeddable(core, plugins) {
    const getStartServices = async () => {
      const [coreStart, deps] = await core.getStartServices();
      return {
        executeTriggerActions: deps.uiActions.executeTriggerActions,
        isEditable: () => coreStart.application.capabilities.discover_v2.save
      };
    };
    const getDiscoverServicesForEmbeddable = async () => {
      const [[coreStart, deps], ebtManager] = await Promise.all([core.getStartServices(), getEmptyEbtManager()]);
      return this.getDiscoverServicesWithProfiles({
        core: coreStart,
        plugins: deps,
        ebtManager
      });
    };
    plugins.embeddable.registerAddFromLibraryType({
      onAdd: async (container, savedObject) => {
        const {
          addControlsFromSavedSession,
          SAVED_OBJECT_REF_NAME
        } = await getEmbeddableServices();
        addControlsFromSavedSession(container, savedObject);
        container.addNewPanel({
          panelType: _discoverUtils.SEARCH_EMBEDDABLE_TYPE,
          serializedState: {
            rawState: {},
            references: [...savedObject.references, {
              name: SAVED_OBJECT_REF_NAME,
              type: _discoverUtils.SEARCH_EMBEDDABLE_TYPE,
              id: savedObject.id
            }]
          }
        }, true);
      },
      savedObjectType: _common.SavedSearchType,
      savedObjectName: _i18n.i18n.translate('discover.savedSearch.savedObjectName', {
        defaultMessage: 'Discover session'
      }),
      getIconForSavedObject: () => 'discoverApp'
    });
    plugins.embeddable.registerReactEmbeddableFactory(_discoverUtils.SEARCH_EMBEDDABLE_TYPE, async () => {
      const [startServices, discoverServices, {
        getSearchEmbeddableFactory
      }] = await Promise.all([getStartServices(), getDiscoverServicesForEmbeddable(), getEmbeddableServices()]);
      return getSearchEmbeddableFactory({
        startServices,
        discoverServices
      });
    });

    // We register a specialized saved search embeddable factory for the log stream embeddable to support old log stream panels.
    plugins.embeddable.registerReactEmbeddableFactory(_constants.LEGACY_LOG_STREAM_EMBEDDABLE, async () => {
      const [startServices, discoverServices, {
        getLegacyLogStreamEmbeddableFactory
      }] = await Promise.all([getStartServices(), getDiscoverServicesForEmbeddable(), getEmbeddableServices()]);
      return getLegacyLogStreamEmbeddableFactory({
        startServices,
        discoverServices
      });
    });
    plugins.embeddable.registerLegacyURLTransform(_discoverUtils.SEARCH_EMBEDDABLE_TYPE, async () => {
      const {
        getSearchEmbeddableTransforms
      } = await getEmbeddableServices();
      const {
        transformEnhancementsIn,
        transformEnhancementsOut
      } = plugins.embeddable;
      return getSearchEmbeddableTransforms(transformEnhancementsIn, transformEnhancementsOut).transformOut;
    });
  }
}
exports.DiscoverPlugin = DiscoverPlugin;
const getLocators = () => Promise.resolve().then(() => _interopRequireWildcard(require('./plugin_imports/locators')));
const getEmbeddableServices = () => Promise.resolve().then(() => _interopRequireWildcard(require('./plugin_imports/embeddable_services')));
const getSharedServices = () => Promise.resolve().then(() => _interopRequireWildcard(require('./plugin_imports/shared_services')));
const getHistoryService = (0, _lodash.once)(async () => {
  const {
    HistoryService
  } = await getSharedServices();
  return new HistoryService();
});
const getEmptyEbtManager = (0, _lodash.once)(async () => {
  const {
    DiscoverEBTManager
  } = await getSharedServices();
  return new DiscoverEBTManager(); // It is not initialized outside of Discover
});