"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedVSAvailableCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/layout/selected_vs_available_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SelectedVSAvailableCallout = ({
  esqlQueryColumns,
  selectedColumns
}) => {
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEsqlMode && esqlQueryColumns && selectedColumns.length > 0 && selectedColumns.length < esqlQueryColumns.length && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "primary",
    "data-test-subj": "dscSelectedColumnsCallout",
    iconType: "info",
    title: _i18n.i18n.translate('discover.esqlMode.selectedColumnsCallout', {
      defaultMessage: 'Displaying {selectedColumnsNumber} of {esqlQueryColumnsNumber} fields. Add more from the Available fields list.',
      values: {
        esqlQueryColumnsNumber: esqlQueryColumns.length,
        selectedColumnsNumber: selectedColumns.length
      }
    }),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }));
};
exports.SelectedVSAvailableCallout = SelectedVSAvailableCallout;