"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIDEBAR_WIDTH_KEY = exports.InternalDiscoverResizableLayout = exports.DiscoverResizableLayout = void 0;
var _eui = require("@elastic/eui");
var _resizableLayout = require("@kbn/resizable-layout");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _reactReversePortal = require("react-reverse-portal");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _discover_layout_restorable_state = require("./discover_layout_restorable_state");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/layout/discover_resizable_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SIDEBAR_WIDTH_KEY = exports.SIDEBAR_WIDTH_KEY = 'discover:sidebarWidth';
const InternalDiscoverResizableLayout = ({
  sidebarToggleState$,
  sidebarPanel,
  mainPanel
}) => {
  var _sidebarToggleState$i;
  const {
    storage
  } = (0, _use_discover_services.useDiscoverServices)();
  const [sidebarPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const [mainPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const minSidebarWidth = euiTheme.base * 13;
  const defaultSidebarWidth = euiTheme.base * 19;
  const minMainPanelWidth = euiTheme.base * 24;
  const [sidebarWidth, setSidebarWidth] = (0, _discover_layout_restorable_state.useRestorableState)('sidebarWidth', () => {
    const widthInLocalStorage = Number(storage === null || storage === void 0 ? void 0 : storage.get(SIDEBAR_WIDTH_KEY));
    return widthInLocalStorage || defaultSidebarWidth;
  }, {
    shouldStoreDefaultValueRightAway: true // otherwise, it would re-initialize with the localStorage value which might get updated in the meantime
  });
  const setSidebarWidthAndUpdateInStorage = (0, _react.useCallback)(width => {
    setSidebarWidth(width);
    storage.set(SIDEBAR_WIDTH_KEY, width);
  }, [setSidebarWidth, storage]);
  const sidebarToggleState = (0, _useObservable.default)(sidebarToggleState$);
  const isSidebarCollapsed = (_sidebarToggleState$i = sidebarToggleState === null || sidebarToggleState === void 0 ? void 0 : sidebarToggleState.isCollapsed) !== null && _sidebarToggleState$i !== void 0 ? _sidebarToggleState$i : false;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const layoutMode = isMobile || isSidebarCollapsed ? _resizableLayout.ResizableLayoutMode.Static : _resizableLayout.ResizableLayoutMode.Resizable;
  const layoutDirection = isMobile ? _resizableLayout.ResizableLayoutDirection.Vertical : _resizableLayout.ResizableLayoutDirection.Horizontal;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: sidebarPanelNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, sidebarPanel), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, mainPanel), /*#__PURE__*/_react.default.createElement(_resizableLayout.ResizableLayout, {
    className: "dscPageBody__contents" // class is used in other styles
    ,
    css: dscPageBodyContentsCss,
    mode: layoutMode,
    direction: layoutDirection,
    fixedPanelSize: sidebarWidth !== null && sidebarWidth !== void 0 ? sidebarWidth : defaultSidebarWidth,
    minFixedPanelSize: minSidebarWidth,
    minFlexPanelSize: minMainPanelWidth,
    fixedPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: sidebarPanelNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 21
      }
    }),
    flexPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 20
      }
    }),
    "data-test-subj": "discoverLayout",
    onFixedPanelSizeChange: setSidebarWidthAndUpdateInStorage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }));
};
exports.InternalDiscoverResizableLayout = InternalDiscoverResizableLayout;
const DiscoverResizableLayout = exports.DiscoverResizableLayout = (0, _discover_layout_restorable_state.withRestorableState)(InternalDiscoverResizableLayout);
const dscPageBodyContentsCss = (0, _react2.css)`
  overflow: hidden;
  height: 100%;
`;