"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContextAppState = useContextAppState;
var _react = require("react");
var _discoverUtils = require("@kbn/discover-utils");
var _context_state = require("../services/context_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useContextAppState({
  services,
  dataView
}) {
  const {
    uiSettings: config,
    history,
    core
  } = services;
  const stateContainer = (0, _react.useMemo)(() => {
    return (0, _context_state.getState)({
      defaultSize: parseInt(config.get(_discoverUtils.CONTEXT_DEFAULT_SIZE_SETTING), 10),
      storeInSessionStorage: config.get('state:storeInSessionStorage'),
      history,
      toasts: core.notifications.toasts,
      uiSettings: config,
      data: services.data,
      dataView
    });
  }, [config, history, core.notifications.toasts, services.data, dataView]);
  const [appState, setAppState] = (0, _react.useState)(stateContainer.appState.getState());
  const [globalState, setGlobalState] = (0, _react.useState)(stateContainer.globalState.getState());

  /**
   * Sync with app state container
   */
  (0, _react.useEffect)(() => {
    stateContainer.startSync();
    return () => stateContainer.stopSync();
  }, [stateContainer]);
  (0, _react.useEffect)(() => {
    const unsubscribeAppState = stateContainer.appState.subscribe(newState => {
      var _newState$filters;
      const newStateEnsureFilter = {
        ...newState,
        filters: (_newState$filters = newState.filters) !== null && _newState$filters !== void 0 ? _newState$filters : []
      };
      setAppState(prevState => ({
        ...prevState,
        ...newStateEnsureFilter
      }));
    });
    const unsubscribeGlobalState = stateContainer.globalState.subscribe(newState => {
      var _newState$filters2;
      const newStateEnsureFilter = {
        ...newState,
        filters: (_newState$filters2 = newState.filters) !== null && _newState$filters2 !== void 0 ? _newState$filters2 : []
      };
      setGlobalState(prevState => ({
        ...prevState,
        ...newStateEnsureFilter
      }));
    });
    return () => {
      unsubscribeAppState();
      unsubscribeGlobalState();
    };
  }, [stateContainer, setAppState]);
  return {
    appState,
    globalState,
    stateContainer
  };
}