"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _translations = require("../../../common/translations");
var _hooks = require("../../hooks");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Header() {
  var _integrationDetails$i, _integrationDetails$i2, _integrationDetails$i3, _integrationDetails$i4, _integrationDetails$i5;
  const {
    datasetDetails,
    timeRange,
    integrationDetails,
    loadingState
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    navigationSources
  } = (0, _hooks.useDatasetDetailsTelemetry)();
  const {
    rawName,
    name: title
  } = datasetDetails;
  const euiShadow = (0, _eui.useEuiShadow)('s');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    navigationSource: navigationSources.Header
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: `${datasetDetails.rawName},${datasetDetails.rawName}${_constants.FAILURE_STORE_SELECTOR}`,
    timeRangeConfig: timeRange,
    sendTelemetry
  });
  const pageTitle = (_integrationDetails$i = integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i2 = integrationDetails.integration) === null || _integrationDetails$i2 === void 0 ? void 0 : (_integrationDetails$i3 = _integrationDetails$i2.integration) === null || _integrationDetails$i3 === void 0 ? void 0 : (_integrationDetails$i4 = _integrationDetails$i3.datasets) === null || _integrationDetails$i4 === void 0 ? void 0 : _integrationDetails$i4[datasetDetails.name]) !== null && _integrationDetails$i !== void 0 ? _integrationDetails$i : title;
  return !loadingState.integrationDetailsLoaded ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
    size: "l",
    "data-test-subj": "datasetQualityDetailsIntegrationLoading",
    className: "datasetQualityDetailsIntegrationLoading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexStart",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexStart",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "datasetQualityDetailsTitle",
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, pageTitle)), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                ${euiShadow};
                padding: ${euiTheme.size.xs};
                border-radius: ${euiTheme.size.xxs};
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_common.IntegrationIcon, {
    integration: integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i5 = integrationDetails.integration) === null || _integrationDetails$i5 === void 0 ? void 0 : _integrationDetails$i5.integration,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react2.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, rawName)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
            margin-right: ${euiTheme.size.l};
          `,
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "datasetQualityDetailsHeaderButton",
    size: "s"
  }, redirectLinkProps.linkProps, {
    iconType: "discoverApp",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }), _translations.openInDiscoverText))));
}