"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsLinks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _kibana_context = require("../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/results_links/results_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RECHECK_DELAY_MS = 3000;
const ResultsLinks = ({
  index,
  dataViewId,
  timeFieldName,
  createDataView,
  showFilebeatFlyout,
  getAdditionalLinks,
  resultLinks
}) => {
  var _resultLinks$fileBeat;
  const {
    services: {
      fileUpload,
      share: {
        url
      },
      application: {
        getUrlForApp,
        capabilities
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const [duration, setDuration] = (0, _react.useState)({
    from: 'now-30m',
    to: 'now'
  });
  const [globalState, setGlobalState] = (0, _react.useState)();
  const [discoverLink, setDiscoverLink] = (0, _react.useState)('');
  const [indexManagementLink, setIndexManagementLink] = (0, _react.useState)('');
  const [dataViewsManagementLink, setDataViewsManagementLink] = (0, _react.useState)('');
  const [playgroundLink, setPlaygroundLink] = (0, _react.useState)('');
  const [asyncHrefCards, setAsyncHrefCards] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    let unmounted = false;
    const getDiscoverUrl = async () => {
      var _capabilities$discove, _capabilities$discove2;
      const isDiscoverAvailable = (_capabilities$discove = (_capabilities$discove2 = capabilities.discover_v2) === null || _capabilities$discove2 === void 0 ? void 0 : _capabilities$discove2.show) !== null && _capabilities$discove !== void 0 ? _capabilities$discove : false;
      if (!isDiscoverAvailable) return;
      const discoverLocator = url.locators.get('DISCOVER_APP_LOCATOR');
      if (!discoverLocator) {
        // eslint-disable-next-line no-console
        console.error('Discover locator not available');
        return;
      }
      const discoverUrl = await discoverLocator.getUrl({
        indexPatternId: dataViewId,
        timeRange: globalState !== null && globalState !== void 0 && globalState.time ? globalState.time : undefined
      });
      if (unmounted) return;
      setDiscoverLink(discoverUrl);
    };
    getDiscoverUrl();
    if (Array.isArray(getAdditionalLinks) && dataViewId !== undefined) {
      Promise.all(getAdditionalLinks.map(async asyncCardGetter => {
        const cardResults = await asyncCardGetter({
          dataViewId,
          globalState
        });
        if (Array.isArray(cardResults)) {
          return await Promise.all(cardResults.map(async c => ({
            ...c,
            canDisplay: await c.canDisplay(),
            href: await c.getUrl()
          })));
        }
      })).then(cards => {
        setAsyncHrefCards((0, _lodash.flatten)(cards).filter(_mlIsDefined.isDefined).filter(d => d.canDisplay === true));
      });
    }
    if (!unmounted) {
      const playgroundLocator = url.locators.get('PLAYGROUND_LOCATOR_ID');
      if (playgroundLocator !== undefined) {
        playgroundLocator.getUrl({
          'default-index': index
        }).then(setPlaygroundLink);
      }
      setIndexManagementLink(getUrlForApp('management', {
        path: '/data/index_management/indices'
      }));
      if (capabilities.indexPatterns.save === true) {
        setDataViewsManagementLink(getUrlForApp('management', {
          path: `/kibana/dataViews${createDataView ? `/dataView/${dataViewId}` : ''}`
        }));
      }
    }
    return () => {
      unmounted = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataViewId, url, JSON.stringify(globalState)]);
  (0, _react.useEffect)(() => {
    updateTimeValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    const _globalState = {
      time: {
        from: duration.from,
        to: duration.to
      }
    };
    setGlobalState(_globalState);
  }, [duration]);
  async function updateTimeValues(recheck = true) {
    if (timeFieldName !== undefined) {
      const {
        from,
        to
      } = await getFullTimeRange(index, timeFieldName, fileUpload);
      setDuration({
        from: from === null ? duration.from : from,
        to: to === null ? duration.to : to
      });

      // these links may have been drawn too quickly for the index to be ready
      // to give us the correct start and end times.
      // especially if the data was small.
      // so if the start and end were null, try again in 3s
      if (recheck && (from === null || to === null)) {
        setTimeout(() => {
          updateTimeValues(false);
        }, RECHECK_DELAY_MS);
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    "data-test-subj": "dataVisualizerFileResultsLinks",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, createDataView && discoverLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: `discoverApp`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 19
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.resultsLinks.viewIndexInDiscoverTitle",
      defaultMessage: "View index in Discover",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 15
      }
    }),
    description: "",
    href: discoverLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  })), indexManagementLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: `managementApp`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 19
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.resultsLinks.indexManagementTitle",
      defaultMessage: "Index Management",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    }),
    description: "",
    href: indexManagementLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  })), dataViewsManagementLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: `managementApp`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 19
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.resultsLinks.dataViewManagementTitle",
      defaultMessage: "Data View Management",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 15
      }
    }),
    description: "",
    href: dataViewsManagementLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  })), (resultLinks === null || resultLinks === void 0 ? void 0 : (_resultLinks$fileBeat = resultLinks.fileBeat) === null || _resultLinks$fileBeat === void 0 ? void 0 : _resultLinks$fileBeat.enabled) !== false && showFilebeatFlyout !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: `filebeatApp`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 19
      }
    }),
    "data-test-subj": "fileDataVisFilebeatConfigLink",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.resultsLinks.fileBeatConfig",
      defaultMessage: "Create Filebeat configuration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 15
      }
    }),
    description: "",
    onClick: showFilebeatFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  })) : null, playgroundLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: `logoElasticsearch`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 19
      }
    }),
    "data-test-subj": "fileDataVisFilebeatConfigLink",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.resultsLinks.playground",
      defaultMessage: "Playground",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 15
      }
    }),
    description: "",
    href: playgroundLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  })) : null, Array.isArray(asyncHrefCards) && asyncHrefCards.map(link => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: link.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: link.icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 21
      }
    }),
    "data-test-subj": "fileDataVisLink",
    title: link.title,
    description: link.description,
    href: link.href,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 13
    }
  }))));
};
exports.ResultsLinks = ResultsLinks;
async function getFullTimeRange(index, timeFieldName, {
  getTimeFieldRange
}) {
  const query = {
    bool: {
      must: [{
        query_string: {
          analyze_wildcard: true,
          query: '*'
        }
      }]
    }
  };
  const resp = await getTimeFieldRange(index, query, timeFieldName);
  return {
    from: (0, _moment.default)(resp.start.epoch).toISOString(),
    to: (0, _moment.default)(resp.end.epoch).toISOString()
  };
}