"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-utils-plugin/common");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/source_filters_table/components/add_filter/add_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sourcePlaceholder = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.sourcePlaceholder', {
  defaultMessage: "field filter, accepts wildcards (e.g., `user*` to filter fields starting with 'user')"
});
const AddFilter = ({
  onAddFilter
}) => {
  const [filter, setFilter] = (0, _react.useState)('');
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const isAddButtonDisabled = filter.length === 0 || isInvalid;
  const onAddButtonClick = (0, _react.useCallback)(() => {
    onAddFilter(filter);
    setFilter('');
  }, [filter, onAddFilter]);
  const onInputChange = (0, _react.useCallback)(e => {
    const value = e.target.value.trim();
    setFilter(value);
  }, [setFilter]);
  const onInputBlur = (0, _react.useCallback)(e => {
    const value = e.target.value.trim();
    if (value.length === 0) {
      setIsInvalid(true);
      return;
    }
    try {
      // test value is not important, just that the created regex is able to compile
      (0, _common.makeRegEx)(value).test('');
      setIsInvalid(false);
    } catch (_) {
      setIsInvalid(true);
      return;
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: filter,
    "data-test-subj": "fieldFilterInput",
    isInvalid: isInvalid,
    onBlur: onInputBlur,
    onChange: onInputChange,
    placeholder: sourcePlaceholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addFieldFilterButton",
    isDisabled: isAddButtonDisabled,
    onClick: onAddButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.source.addButtonLabel",
    defaultMessage: "Add",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))));
};
exports.AddFilter = AddFilter;