"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelationshipsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _plugin = require("../../../plugin");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/relationships_table/relationships_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const canGoInApp = (savedObject, capabilities) => {
  const {
    inAppUrl
  } = savedObject.meta;
  if (!inAppUrl) return false;
  if (!inAppUrl.uiCapabilitiesPath) return true;
  return Boolean((0, _lodash.get)(capabilities, inAppUrl.uiCapabilitiesPath));
};
const RelationshipsTable = ({
  basePath,
  capabilities,
  id,
  navigateToUrl,
  getDefaultTitle,
  getSavedObjectLabel,
  relationships,
  allowedTypes,
  savedObjectsTagging
}) => {
  const columns = [{
    field: 'type',
    name: _i18n.typeFieldName,
    width: '50px',
    align: 'center',
    description: _i18n.typeFieldDescription,
    sortable: false,
    render: (type, object) => {
      const typeLabel = getSavedObjectLabel(type, allowedTypes);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: typeLabel,
        position: "top",
        "aria-label": typeLabel,
        type: object.meta.icon || 'apps',
        size: "s",
        iconProps: {
          'data-test-subj': 'relationshipsObjectType'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'title',
    name: _i18n.titleFieldName,
    description: _i18n.titleFieldDescription,
    dataType: 'string',
    sortable: false,
    render: (title, object) => {
      var _object$meta$inAppUrl, _object$references;
      const path = ((_object$meta$inAppUrl = object.meta.inAppUrl) === null || _object$meta$inAppUrl === void 0 ? void 0 : _object$meta$inAppUrl.path) || '';
      const showUrl = canGoInApp(object, capabilities);
      const titleDisplayed = title || getDefaultTitle(object);
      const TagListComponent = savedObjectsTagging === null || savedObjectsTagging === void 0 ? void 0 : savedObjectsTagging.ui.components.TagList;
      const isManaged = object.managed === true;
      const hasTags = ((_object$references = object.references) === null || _object$references === void 0 ? void 0 : _object$references.some(ref => ref.type === 'tag')) === true;
      const showTags = !!TagListComponent && hasTags;
      const showBadges = isManaged || showTags;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 11
        }
      }, showUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: basePath.prepend(path),
        "data-test-subj": "relationshipsTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, titleDisplayed) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        "data-test-subj": "relationshipsTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 15
        }
      }, titleDisplayed), showBadges && /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 15
        }
      }, isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "managedBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 19
        }
      }, _i18n.managedBadge), showTags && /*#__PURE__*/_react.default.createElement(TagListComponent, {
        object: object,
        "data-test-subj": "relationshipsTags",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 19
        }
      })));
    }
  }];
  const filterTypesMap = new Map(relationships.map(relationship => [relationship.type, {
    value: relationship.type,
    name: relationship.type,
    view: relationship.type
  }]));
  const search = {
    // query,
    // onChange: handleOnChange,
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.filterTitle,
      multiSelect: 'or',
      options: [...filterTypesMap.values()]
    }]
  };
  const {
    pageSize,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'dataViewMgmtRelationships',
    initialPageSize: 10
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    currentAppId: _plugin.IPM_APP_ID,
    navigateToUrl: navigateToUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: relationships,
    columns: columns,
    pagination: {
      pageSize
    },
    onTableChange: onTableChange,
    search: search,
    rowProps: () => ({
      'data-test-subj': `relationshipsTableRow`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }));
};
exports.RelationshipsTable = RelationshipsTable;