"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDataViewFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _delete_data_view_flyout_content = require("./delete_data_view_flyout_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/delete_data_view_flyout/delete_data_view_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DeleteDataViewFlyout = ({
  dataViews,
  dataViewArray,
  selectedRelationships,
  hasSpaces,
  onDelete,
  onClose
}) => {
  const {
    notifications
  } = (0, _public.useKibana)().services;
  const [reviewedItems, setReviewedItems] = _react.default.useState(new Set());
  const onModalClose = () => {
    setReviewedItems(new Set());
    onClose();
  };
  const deleteDataViews = async () => {
    (0, _std.asyncForEach)(dataViewArray, async ({
      id
    }) => dataViews.delete(id)).then(() => {
      onDelete();
      notifications.toasts.addSuccess(_i18n.i18n.translate('indexPatternManagement.dataViewTable.deleteSuccessToast', {
        defaultMessage: 'Successfully deleted {count, number} {count, plural, one {data view} other {data views}}.',
        values: {
          count: dataViewArray.length
        }
      }));
    }).catch(error => {
      notifications.toasts.addDanger(error);
    });
  };
  const complicatedFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'deleteDataViewFlyoutTitle'
  });
  const disableDeleteButton = _react.default.useMemo(() => {
    return reviewedItems.size !== Object.values(selectedRelationships).filter(relations => relations.length > 0).length;
  }, [reviewedItems, selectedRelationships]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onModalClose,
    "data-test-subj": "deleteDataViewFlyout",
    "aria-label": "deleteDataViewFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "deleteDataViewFlyoutHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: complicatedFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('indexPatternManagement.deleteDataView.flyoutTitle', {
    defaultMessage: 'Delete Data View'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "delete-modal-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_delete_data_view_flyout_content.DeleteModalContent, {
    reviewedItems: reviewedItems,
    setReviewedItems: setReviewedItems,
    views: dataViewArray,
    hasSpaces: hasSpaces,
    relationships: selectedRelationships,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onModalClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('indexPatternManagement.deleteDataView.cancelButton', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: deleteDataViews,
    color: "danger",
    fill: true,
    disabled: disableDeleteButton,
    "data-test-subj": "confirmFlyoutConfirmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('indexPatternManagement.deleteDataView.deleteButton', {
    defaultMessage: 'Delete'
  }))))));
};
exports.DeleteDataViewFlyout = DeleteDataViewFlyout;