"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardUrlParams = void 0;
exports.mountApp = mountApp;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _page_bundle_constants = require("../../common/page_bundle_constants");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
var _dashboard_app_strings = require("./_dashboard_app_strings");
var _dashboard_app = require("./dashboard_app");
var _dashboard_mount_context = require("./hooks/dashboard_mount_context");
var _dashboard_listing_page = require("./listing_page/dashboard_listing_page");
var _dashboard_no_match = require("./listing_page/dashboard_no_match");
var _urls = require("../utils/urls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/dashboard_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const dashboardUrlParams = exports.dashboardUrlParams = {
  showTopMenu: 'show-top-menu',
  showQueryInput: 'show-query-input',
  showTimeFilter: 'show-time-filter',
  hideFilterBar: 'hide-filter-bar'
};
async function mountApp({
  coreStart,
  element,
  appUnMounted,
  mountContext
}) {
  let globalEmbedSettings;
  const getUrlStateStorage = history => (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: _kibana_services.coreServices.uiSettings.get('state:storeInSessionStorage')
  });
  const redirect = redirectTo => {
    let path;
    let state;
    if (redirectTo.destination === 'dashboard') {
      path = redirectTo.id ? (0, _urls.createDashboardEditUrl)(redirectTo.id) : _urls.CREATE_NEW_DASHBOARD_URL;
      if (redirectTo.editMode) {
        state = {
          viewMode: 'edit'
        };
      }
    } else {
      path = (0, _urls.createDashboardListingFilterUrl)(redirectTo.filter);
    }
    _kibana_services.coreServices.application.navigateToApp(_page_bundle_constants.DASHBOARD_APP_ID, {
      path: `#/${path}`,
      state,
      replace: redirectTo.useReplace
    });
  };
  const getDashboardEmbedSettings = routeParams => {
    return {
      forceShowTopNavMenu: routeParams[dashboardUrlParams.showTopMenu] === 'true',
      forceShowQueryInput: routeParams[dashboardUrlParams.showQueryInput] === 'true',
      forceShowDatePicker: routeParams[dashboardUrlParams.showTimeFilter] === 'true',
      forceHideFilterBar: routeParams[dashboardUrlParams.hideFilterBar] === 'true'
    };
  };
  const renderDashboard = routeProps => {
    var _routeProps$match$par;
    const routeParams = (0, _queryString.parse)(routeProps.history.location.search);
    if (routeParams.embed === 'true' && !globalEmbedSettings) {
      globalEmbedSettings = getDashboardEmbedSettings(routeParams);
    }
    return /*#__PURE__*/_react.default.createElement(_dashboard_app.DashboardApp, {
      key: (_routeProps$match$par = routeProps.match.params.id) !== null && _routeProps$match$par !== void 0 ? _routeProps$match$par : 'newDashboard',
      history: routeProps.history,
      embedSettings: globalEmbedSettings,
      savedDashboardId: routeProps.match.params.id,
      redirectTo: redirect,
      expandedPanelId: routeProps.match.params.expandedPanelId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    });
  };
  const renderListingPage = routeProps => {
    _kibana_services.coreServices.chrome.docTitle.change((0, _dashboard_app_strings.getDashboardPageTitle)());
    const routeParams = (0, _queryString.parse)(routeProps.history.location.search);
    const title = routeParams.title || undefined;
    const filter = routeParams.filter || undefined;
    return /*#__PURE__*/_react.default.createElement(_dashboard_listing_page.DashboardListingPage, {
      initialFilter: filter,
      title: title,
      kbnUrlStateStorage: getUrlStateStorage(routeProps.history),
      redirectTo: redirect,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 7
      }
    });
  };
  const renderNoMatch = routeProps => {
    return /*#__PURE__*/_react.default.createElement(_dashboard_no_match.DashboardNoMatch, {
      history: routeProps.history,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 12
      }
    });
  };
  const hasEmbeddableIncoming = Boolean(_kibana_services.embeddableService.getStateTransfer().getIncomingEmbeddablePackage(_page_bundle_constants.DASHBOARD_APP_ID, false));
  if (!hasEmbeddableIncoming) {
    _kibana_services.dataService.dataViews.clearCache();
  }

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlistenParentHistory = mountContext.scopedHistory().listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  const app = /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_dashboard_mount_context.DashboardMountContext.Provider, {
    value: mountContext,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.HashRouter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: [_urls.CREATE_NEW_DASHBOARD_URL, `${_urls.VIEW_DASHBOARD_URL}/:id/:expandedPanelId`, `${_urls.VIEW_DASHBOARD_URL}/:id`],
    render: renderDashboard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _page_bundle_constants.LANDING_PAGE_PATH,
    render: renderListingPage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _page_bundle_constants.LANDING_PAGE_PATH,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: renderNoMatch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  })))));
  _kibana_services.coreServices.chrome.setHelpExtension({
    appName: (0, _dashboard_app_strings.getDashboardPageTitle)(),
    links: [{
      linkType: 'documentation',
      href: `${_kibana_services.coreServices.docLinks.links.dashboard.guide}`
    }]
  });
  if (!(0, _get_dashboard_capabilities.getDashboardCapabilities)().showWriteControls) {
    _kibana_services.coreServices.chrome.setBadge({
      text: _dashboard_app_strings.dashboardReadonlyBadge.getText(),
      tooltip: _dashboard_app_strings.dashboardReadonlyBadge.getTooltip(),
      iconType: 'glasses'
    });
  }
  (0, _reactDom.render)(app, element);
  return () => {
    _kibana_services.dataService.search.session.clear();
    unlistenParentHistory();
    (0, _reactDom.unmountComponentAtNode)(element);
    appUnMounted();
  };
}