"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownEmbeddableSchema = exports.markdownEditorSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _presentationPublishingSchemas = require("@kbn/presentation-publishing-schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const markdownEditorSchema = exports.markdownEditorSchema = _configSchema.schema.object({
  content: _configSchema.schema.string()
});
const markdownEmbeddableSchema = exports.markdownEmbeddableSchema = _configSchema.schema.allOf([markdownEditorSchema, _presentationPublishingSchemas.serializedTitlesSchema], {
  meta: {
    description: 'Markdown embeddable schema'
  }
});