"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplacementCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _services = require("../../services");
var _replacement_card = require("./replacement_card.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/custom_integrations/public/components/replacement_card/replacement_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * A data-connected component which can query about Beats-based replacement options for a given EPR module.
 */
const ReplacementCard = ({
  eprPackageName
}) => {
  const {
    findReplacementIntegrations
  } = (0, _services.useFindService)();
  const integrations = (0, _useAsync.default)(async () => {
    return await findReplacementIntegrations({
      shipper: 'beats',
      eprPackageName
    });
  }, [eprPackageName]);
  const {
    loading,
    value: replacements
  } = integrations;
  if (loading || !replacements || replacements.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_replacement_card.ReplacementCard, {
    replacements,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 10
    }
  });
};
exports.ReplacementCard = ReplacementCard;