"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.PluginsConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _lodash = require("lodash");
var _projectsSolutionsGroups = require("@kbn/projects-solutions-groups");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const configSchema = _configSchema.schema.object({
  initialize: _configSchema.schema.boolean({
    defaultValue: true
  }),
  /**
   * Defines an array of directories where another plugin should be loaded from.
   */
  paths: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  /**
   * Defines an array of groups to include when loading plugins.
   * Plugins from all groups will be taken into account if the parameter is not provided.
   */
  allowlistPluginGroups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf(_projectsSolutionsGroups.KIBANA_GROUPS.map(groupName => _configSchema.schema.literal(groupName))))),
  /**
   * Internal config, not intended to be used by end users. Only for specific
   * internal purposes.
   */
  forceEnableAllPlugins: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false
  }))
});
const config = exports.config = {
  path: 'plugins',
  schema: configSchema
};

/** @internal */
class PluginsConfig {
  constructor(rawConfig, env) {
    /**
     * Indicates whether or not plugins should be initialized.
     */
    (0, _defineProperty2.default)(this, "initialize", void 0);
    /**
     * Defines directories that we should scan for the plugin subdirectories.
     */
    (0, _defineProperty2.default)(this, "pluginSearchPaths", void 0);
    /**
     * Defines directories where an additional plugin exists.
     */
    (0, _defineProperty2.default)(this, "additionalPluginPaths", void 0);
    /**
     * Whether to enable all plugins.
     *
     * @note this is intended to be an undocumented setting.
     */
    (0, _defineProperty2.default)(this, "shouldEnableAllPlugins", void 0);
    /**
     * Specify an allowlist of plugin groups.
     * Allows reducing the amount of plugins that are taken into account.
     * The list will default to "all plugin groups" if the config is not present.
     */
    (0, _defineProperty2.default)(this, "allowlistPluginGroups", void 0);
    this.initialize = rawConfig.initialize;
    this.pluginSearchPaths = env.pluginSearchPaths;
    this.additionalPluginPaths = rawConfig.paths;
    this.allowlistPluginGroups = (0, _lodash.get)(rawConfig, _constants.INCLUDED_PLUGIN_GROUPS);
    this.shouldEnableAllPlugins = (0, _lodash.get)(rawConfig, _constants.ENABLE_ALL_PLUGINS_CONFIG_PATH, false);
  }
}
exports.PluginsConfig = PluginsConfig;