"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocalObjectStorage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class LocalObjectStorage {
  constructor(client, type) {
    (0, _defineProperty2.default)(this, "prefix", void 0);
    this.client = client;
    this.prefix = `console_local_${type}`;
  }
  async create(obj) {
    const id = (0, _uuid.v4)();
    const newObj = {
      id,
      ...obj
    };
    this.client.set(`${this.prefix}_${id}`, newObj);
    return newObj;
  }
  async update(obj) {
    this.client.set(`${this.prefix}_${obj.id}`, obj);
  }
  async findAll() {
    const allLocalKeys = this.client.keys().filter(key => {
      return key.includes(this.prefix);
    });
    const result = [];
    for (const key of allLocalKeys) {
      result.push(this.client.get(key));
    }
    return result;
  }
}
exports.LocalObjectStorage = LocalObjectStorage;