"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = exports.API_MAX_RESULTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.crowdStrike.title', {
  defaultMessage: 'CrowdStrike'
});
const CONNECTOR_ID = exports.CONNECTOR_ID = '.crowdstrike';
const API_MAX_RESULTS = exports.API_MAX_RESULTS = 1000;
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["GET_AGENT_DETAILS"] = "getAgentDetails";
  SUB_ACTION["HOST_ACTIONS"] = "hostActions";
  SUB_ACTION["GET_AGENT_ONLINE_STATUS"] = "getAgentOnlineStatus";
  SUB_ACTION["EXECUTE_RTR_COMMAND"] = "executeRTRCommand";
  SUB_ACTION["EXECUTE_ACTIVE_RESPONDER_RTR"] = "batchActiveResponderExecuteRTR";
  SUB_ACTION["EXECUTE_ADMIN_RTR"] = "batchAdminExecuteRTR";
  SUB_ACTION["GET_RTR_CLOUD_SCRIPTS"] = "getRTRCloudScripts";
  return SUB_ACTION;
}({});