"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _auth = require("../../common/auth");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HeadersSchema = _zod.z.record(_zod.z.string(), _zod.z.string());
const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  createIncidentUrl: _zod.z.string(),
  createIncidentMethod: _zod.z.enum([_auth.WebhookMethods.POST, _auth.WebhookMethods.PUT]).default(_auth.WebhookMethods.POST),
  createIncidentJson: _zod.z.string(),
  // stringified object
  createIncidentResponseKey: _zod.z.string(),
  getIncidentMethod: _zod.z.enum([_auth.WebhookMethods.GET, _auth.WebhookMethods.POST]).default(_auth.WebhookMethods.GET),
  getIncidentUrl: _zod.z.string(),
  getIncidentJson: _zod.z.string().nullable().default(null),
  getIncidentResponseExternalTitleKey: _zod.z.string(),
  viewIncidentUrl: _zod.z.string(),
  updateIncidentUrl: _zod.z.string(),
  updateIncidentMethod: _zod.z.enum([_auth.WebhookMethods.POST, _auth.WebhookMethods.PATCH, _auth.WebhookMethods.PUT]).default(_auth.WebhookMethods.PUT),
  updateIncidentJson: _zod.z.string(),
  createCommentUrl: _zod.z.string().nullable().default(null),
  createCommentMethod: _zod.z.enum([_auth.WebhookMethods.POST, _auth.WebhookMethods.PUT, _auth.WebhookMethods.PATCH]).default(_auth.WebhookMethods.PUT).nullable(),
  createCommentJson: _zod.z.string().nullable().default(null),
  headers: HeadersSchema.nullable().default(null),
  hasAuth: _auth.AuthConfiguration.hasAuth,
  authType: _auth.AuthConfiguration.authType,
  certType: _auth.AuthConfiguration.certType,
  ca: _auth.AuthConfiguration.ca,
  verificationMode: _auth.AuthConfiguration.verificationMode,
  accessTokenUrl: _auth.AuthConfiguration.accessTokenUrl,
  clientId: _auth.AuthConfiguration.clientId,
  scope: _auth.AuthConfiguration.scope,
  additionalFields: _auth.AuthConfiguration.additionalFields
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _zod.z.object(ExternalIncidentServiceConfiguration).strict();
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _zod.z.object({
  incident: _zod.z.object({
    title: _zod.z.string(),
    description: _zod.z.string().nullable().default(null),
    id: _zod.z.string().nullable().default(null),
    severity: _zod.z.string().nullable().default(null),
    status: _zod.z.string().nullable().default(null),
    externalId: _zod.z.string().nullable().default(null),
    tags: _zod.z.array(_zod.z.string()).nullable().default(null)
  }).strict(),
  comments: _zod.z.array(_zod.z.object({
    comment: _zod.z.string(),
    commentId: _zod.z.string()
  }).strict()).nullable().default(null)
}).strict();
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _zod.z.discriminatedUnion('subAction', [_zod.z.object({
  subAction: _zod.z.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchema
}).strict()]);
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _auth.SecretConfigurationSchema;