"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderEndzoneTooltip = exports.getAdjustedInterval = exports.Endzones = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/charts/public/static/components/endzones.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Endzones = ({
  isDarkMode,
  domainStart,
  domainEnd,
  interval,
  domainMin,
  domainMax,
  hideTooltips = true,
  isFullBin = false
}) => {
  const rectAnnotationStyle = {
    stroke: isDarkMode ? _uiTheme.euiDarkVars.euiColorLightShade : _uiTheme.euiLightVars.euiColorDarkShade,
    strokeWidth: 0,
    opacity: isDarkMode ? 0.6 : 0.2,
    fill: isDarkMode ? _uiTheme.euiDarkVars.euiColorLightShade : _uiTheme.euiLightVars.euiColorDarkShade
  };
  const rectAnnotations = [];
  if (domainStart > domainMin) {
    rectAnnotations.push({
      coordinates: {
        x1: isFullBin ? domainMin : domainStart
      }
    });
  }
  if (domainEnd - interval < domainMax) {
    rectAnnotations.push({
      coordinates: {
        x0: isFullBin ? domainMax : domainEnd
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: "__endzones__",
    hideTooltips: hideTooltips,
    customTooltipDetails: Prompt,
    zIndex: 2,
    dataValues: rectAnnotations,
    style: rectAnnotationStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.Endzones = Endzones;
const findIntervalFromDuration = (dateValue, esValue, esUnit, timeZone) => {
  const date = _moment.default.tz(dateValue, timeZone);
  const startOfDate = _moment.default.tz(date, timeZone).startOf(esUnit);
  const endOfDate = _moment.default.tz(date, timeZone).startOf(esUnit).add(esValue, esUnit);
  return endOfDate.valueOf() - startOfDate.valueOf();
};
const getIntervalInMs = (value, esValue, esUnit, timeZone) => {
  switch (esUnit) {
    case 's':
      return 1000 * esValue;
    case 'ms':
      return 1 * esValue;
    default:
      return findIntervalFromDuration(value, esValue, esUnit, timeZone);
  }
};

/**
 * Returns the adjusted interval based on the data
 *
 * @param xValues sorted and unquie x values
 * @param esValue
 * @param esUnit
 * @param timeZone
 */
const getAdjustedInterval = (xValues, esValue, esUnit, timeZone) => {
  const newInterval = xValues.reduce((minInterval, currentXvalue, index) => {
    let currentDiff = minInterval;
    if (index > 0) {
      currentDiff = Math.abs(xValues[index - 1] - currentXvalue);
    }
    const singleUnitInterval = getIntervalInMs(currentXvalue, esValue, esUnit, timeZone);
    return Math.min(minInterval, singleUnitInterval, currentDiff);
  }, Number.MAX_SAFE_INTEGER);
  return newInterval > 0 ? newInterval : _moment.default.duration(esValue, esUnit).asMilliseconds();
};
exports.getAdjustedInterval = getAdjustedInterval;
const partialDataText = _i18n.i18n.translate('charts.partialData.bucketTooltipText', {
  defaultMessage: 'The selected time range does not include this entire bucket. It might contain partial data.'
});
const Prompt = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerPartialCss = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.regular};
    min-width: ${euiTheme.base * 12};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "xs",
    css: headerPartialCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, partialDataText));
};
const renderEndzoneTooltip = (xInterval, domainStart, domainEnd, formatter, renderValue = true) => headerData => {
  const headerDataValue = headerData.value;
  const formattedValue = formatter ? formatter(headerDataValue) : headerDataValue;
  if (domainStart !== undefined && domainStart > headerDataValue || domainEnd !== undefined && xInterval !== undefined && domainEnd - xInterval < headerDataValue) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Prompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }), renderValue && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    }, formattedValue)));
  }
  return renderValue ? formattedValue : null;
};
exports.renderEndzoneTooltip = renderEndzoneTooltip;