"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesToast = exports.CaseToastSuccessContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _owner = require("../../common/utils/owner");
var _domain = require("../../common/types/domain");
var _kibana = require("./lib/kibana");
var _navigation = require("./navigation");
var _translations = require("./translations");
var _constants = require("../../common/constants");
var _use_application = require("./lib/kibana/use_application");
var _truncated_text = require("../components/truncated_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/common/use_cases_toast.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getAlertsCount(attachments) {
  let alertsCount = 0;
  for (const attachment of attachments) {
    if (attachment.type === _domain.AttachmentType.alert) {
      // alertId might be an array
      if (Array.isArray(attachment.alertId) && attachment.alertId.length > 1) {
        alertsCount += attachment.alertId.length;
      } else {
        // or might be a single string
        alertsCount++;
      }
    }
  }
  return alertsCount;
}
function getToastTitle({
  theCase,
  title,
  attachments
}) {
  if (title !== undefined) {
    return title;
  }
  if (attachments !== undefined) {
    const alertsCount = getAlertsCount(attachments);
    if (alertsCount > 0) {
      return (0, _translations.CASE_ALERT_SUCCESS_TOAST)(theCase.title, alertsCount);
    }
  }
  return (0, _translations.CASE_SUCCESS_TOAST)(theCase.title);
}
function getToastContent({
  theCase,
  content,
  attachments
}) {
  if (content !== undefined) {
    return content;
  }
  let toastContent;
  if (attachments !== undefined) {
    for (const attachment of attachments) {
      if (attachment.type === _domain.AttachmentType.alert) {
        if (theCase.settings.syncAlerts && theCase.settings.extractObservables) {
          toastContent = _translations.CASE_ALERT_SUCCESS_SYNC_AND_EXTRACT_TEXT;
        } else if (theCase.settings.syncAlerts) {
          toastContent = _translations.CASE_ALERT_SUCCESS_SYNC_TEXT;
        } else if (theCase.settings.extractObservables) {
          toastContent = _translations.CASE_ALERT_SUCCESS_OBSERVABLES_TEXT;
        }
      }
    }
  }
  return toastContent;
}
const isServerError = error => Object.hasOwn(error, 'body');
const getError = error => {
  if (isServerError(error)) {
    var _error$body;
    return new Error((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message);
  }
  return error;
};
const getErrorMessage = error => {
  if (isServerError(error)) {
    var _error$body$message, _error$body2;
    return (_error$body$message = (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message !== void 0 ? _error$body$message : '';
  }
  return error.message;
};
const useCasesToast = () => {
  const {
    appId
  } = (0, _use_application.useApplication)();
  const {
    application,
    i18n,
    theme,
    userProfile
  } = (0, _kibana.useKibana)().services;
  const {
    getUrlForApp,
    navigateToUrl
  } = application;
  const toasts = (0, _kibana.useToasts)();
  return (0, _react.useMemo)(() => ({
    showSuccessAttach: ({
      theCase,
      attachments,
      observables,
      title,
      content
    }) => {
      const appIdToNavigateTo = (0, _owner.isValidOwner)(theCase.owner) ? _constants.OWNER_INFO[theCase.owner].appId : appId;
      const url = appIdToNavigateTo != null ? getUrlForApp(appIdToNavigateTo, {
        deepLinkId: 'cases',
        path: (0, _navigation.generateCaseViewPath)({
          detailName: theCase.id
        })
      }) : null;
      const onViewCaseClick = () => {
        if (url) {
          navigateToUrl(url);
        }
      };
      const renderTitle = getToastTitle({
        theCase,
        title,
        attachments
      });
      const renderContent = getToastContent({
        theCase,
        content,
        attachments
      });
      return toasts.addSuccess({
        color: 'success',
        iconType: 'check',
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
          text: renderTitle,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 172,
            columnNumber: 31
          }
        }), {
          i18n,
          theme,
          userProfile
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(CaseToastSuccessContent, {
          content: renderContent,
          onViewCaseClick: url != null ? onViewCaseClick : undefined,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 13
          }
        }), {
          i18n,
          theme,
          userProfile
        })
      });
    },
    showErrorToast: (error, opts) => {
      if (error.name !== 'AbortError') {
        toasts.addError(getError(error), {
          title: getErrorMessage(error),
          ...opts
        });
      }
    },
    showSuccessToast: title => {
      toasts.addSuccess({
        title,
        className: 'eui-textBreakWord'
      });
    },
    showDangerToast: (title, text) => {
      toasts.addDanger({
        title,
        text,
        className: 'eui-textBreakWord'
      });
    },
    showInfoToast: (title, text) => {
      toasts.addInfo({
        title,
        text,
        className: 'eui-textBreakWord'
      });
    }
  }), [i18n, theme, userProfile, appId, getUrlForApp, navigateToUrl, toasts]);
};
exports.useCasesToast = useCasesToast;
const CaseToastSuccessContent = ({
  onViewCaseClick,
  content
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
            ${(0, _eui.logicalCSS)('margin-bottom', euiTheme.size.s)};
          `,
    "data-test-subj": "toaster-content-sync-text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, content) : null, onViewCaseClick !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onViewCaseClick,
    "data-test-subj": "toaster-content-case-view-link",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }, _translations.VIEW_CASE))) : null);
};
exports.CaseToastSuccessContent = CaseToastSuccessContent;
CaseToastSuccessContent.displayName = 'CaseToastSuccessContent';