"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsObservabilityAgentEnabled = getIsObservabilityAgentEnabled;
var _feature_flag = require("../../../common/observability_agent/feature_flag");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIsObservabilityAgentEnabled(core) {
  const [coreStart] = await core.getStartServices();
  return coreStart.featureFlags.getBooleanValue(_feature_flag.OBSERVABILITY_AGENT_FEATURE_FLAG, _feature_flag.OBSERVABILITY_AGENT_FEATURE_FLAG_DEFAULT);
}