"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpanLinksTabContent = getSpanLinksTabContent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
var _technical_preview_badge = require("../technical_preview_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/span_links/span_links_tab_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getSpanLinksTabContent({
  spanLinksCount,
  traceId,
  spanId,
  processorEvent
}) {
  if (!spanLinksCount.linkedChildren && !spanLinksCount.linkedParents || !traceId || !spanId) {
    return undefined;
  }
  return {
    id: 'span_links',
    'data-test-subj': 'spanLinksTab',
    prepend: /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 14
      }
    }),
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.spanLinks', {
      defaultMessage: 'Span links'
    })),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }, spanLinksCount.linkedChildren + spanLinksCount.linkedParents),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_.SpanLinks, {
      spanLinksCount: spanLinksCount,
      traceId: traceId,
      spanId: spanId,
      processorEvent: processorEvent,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }))
  };
}