"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterByTransactionType = exports.filterByTransactionNameOrSpanName = exports.filterBySpanId = exports.filterByServiceName = exports.filterBySampleRange = exports.filterByKuery = exports.filterByErrorGroupId = exports.filterByEnvironment = exports.filterByDependencyName = void 0;
var _esqlComposer = require("@kbn/esql-composer");
var _apmTypes = require("@kbn/apm-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterByKuery = kuery => {
  return (0, _esqlComposer.where)(`KQL("${kuery.trim().replaceAll('"', '\\"').replaceAll(/\s+/g, ' ').replaceAll(/\n+/g, ' ')}")`);
};
exports.filterByKuery = filterByKuery;
const filterByServiceName = serviceName => {
  return (0, _esqlComposer.where)(`${_apmTypes.SERVICE_NAME} == ?serviceName`, {
    serviceName
  });
};
exports.filterByServiceName = filterByServiceName;
const filterByErrorGroupId = errorGroupId => {
  return (0, _esqlComposer.where)(`${_apmTypes.ERROR_GROUP_ID} == ?errorGroupId`, {
    errorGroupId
  });
};
exports.filterByErrorGroupId = filterByErrorGroupId;
const filterByEnvironment = environment => {
  return (0, _esqlComposer.where)(`${_apmTypes.SERVICE_ENVIRONMENT} == ?environment`, {
    environment
  });
};
exports.filterByEnvironment = filterByEnvironment;
const filterByTransactionNameOrSpanName = (transactionName, spanName) => {
  return (0, _esqlComposer.where)(`??nameField == ?name`, {
    nameField: transactionName ? _apmTypes.TRANSACTION_NAME : _apmTypes.SPAN_NAME,
    name: transactionName !== null && transactionName !== void 0 ? transactionName : spanName
  });
};
exports.filterByTransactionNameOrSpanName = filterByTransactionNameOrSpanName;
const filterByTransactionType = transactionType => {
  return (0, _esqlComposer.where)(`${_apmTypes.TRANSACTION_TYPE} == ?transactionType`, {
    transactionType
  });
};
exports.filterByTransactionType = filterByTransactionType;
const filterByDependencyName = dependencyName => {
  return (0, _esqlComposer.where)(`${_apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE} == ?dependencyName`, {
    dependencyName
  });
};
exports.filterByDependencyName = filterByDependencyName;
const filterBySpanId = spanId => {
  return (0, _esqlComposer.where)(`${_apmTypes.SPAN_ID} == ?spanId`, {
    spanId
  });
};
exports.filterBySpanId = filterBySpanId;
const filterBySampleRange = (sampleRangeFrom, sampleRangeTo, transactionName) => {
  return (0, _esqlComposer.where)(`??durationField >= ?sampleRangeFrom AND ??durationField <= ?sampleRangeTo`, {
    durationField: transactionName ? _apmTypes.TRANSACTION_DURATION : _apmTypes.SPAN_DURATION,
    sampleRangeFrom,
    sampleRangeTo
  });
};
exports.filterBySampleRange = filterBySampleRange;