"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Indicator = void 0;
exports.Legend = Legend;
exports.Shape = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Shape = exports.Shape = /*#__PURE__*/function (Shape) {
  Shape["circle"] = "circle";
  Shape["square"] = "square";
  return Shape;
}({});
const Container = _styled.default.div`
  display: flex;
  align-items: center;
  font-size: ${() => (0, _eui.useEuiFontSize)('s').fontSize};
  color: ${({
  theme
}) => theme.euiTheme.colors.darkShade};
  cursor: ${props => props.clickable ? 'pointer' : 'initial'};
  opacity: ${props => props.disabled ? 0.4 : 1};
  user-select: none;
`;
const radius = 11;
const Indicator = exports.Indicator = _styled.default.span`
  width: ${radius}px;
  height: ${radius}px;
  margin-right: ${props => props.withMargin ? `${radius / 2}px` : 0};
  background: ${props => props.color};
  border-radius: ${props => {
  return props.shape === Shape.circle ? '100%' : '0';
}};
`;
function Legend({
  onClick,
  text,
  color,
  disabled = false,
  clickable = false,
  shape = Shape.circle,
  indicator,
  ...rest
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const indicatorColor = color || euiTheme.colors.vis.euiColorVis1;
  return /*#__PURE__*/_react.default.createElement(Container, (0, _extends2.default)({
    onClick: onClick,
    disabled: disabled,
    clickable: clickable || Boolean(onClick)
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }), indicator ? indicator : /*#__PURE__*/_react.default.createElement(Indicator, {
    color: indicatorColor,
    shape: shape,
    withMargin: !!text,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }), text);
}