"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreakdownChart = BreakdownChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _viz_colors = require("../../../../../common/viz_colors");
var _formatters = require("../../../../../common/utils/formatters");
var _use_chart_pointer_event_context = require("../../../../context/chart_pointer_event/use_chart_pointer_event_context");
var _style = require("../../../../utils/style");
var _chart_container = require("../chart_container");
var _helper = require("../helper/helper");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _helper2 = require("../transaction_charts/helper");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _timezone = require("../helper/timezone");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/breakdown_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const asPercentBound = y => (0, _formatters.asPercent)(y, 1);
function BreakdownChart({
  fetchStatus,
  height = _style.unit * 16,
  showAnnotations,
  annotations,
  timeseries,
  yAxisType,
  id
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const chartThemes = (0, _public.useChartThemes)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    chartRef,
    updatePointerEvent
  } = (0, _use_chart_pointer_event_context.useChartPointerEventContext)();
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const min = _moment.default.utc(start).valueOf();
  const max = _moment.default.utc(end).valueOf();
  const xFormatter = (0, _charts.niceTimeFormatter)([min, max]);
  const annotationColor = euiTheme.colors.accentSecondary;
  const isEmpty = (0, _helper.isTimeseriesEmpty)(timeseries);
  const maxY = (0, _helper2.getMaxY)(timeseries);
  const yTickFormat = yAxisType === 'duration' ? (0, _helper2.getResponseTimeTickFormatter)((0, _formatters.getDurationFormatter)(maxY)) : asPercentBound;
  const timeZone = (0, _timezone.getTimeZone)(core.uiSettings);
  return /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    height: height,
    hasData: !isEmpty,
    status: fetchStatus,
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    stickTo: "top",
    showNullValues: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: event => (0, _helper.onBrushEnd)({
      x: event.x,
      history
    }),
    showLegend: true,
    legendValues: [_charts.LegendValue.CurrentAndLastValue],
    legendPosition: _charts.Position.Bottom,
    theme: chartThemes.theme,
    baseTheme: chartThemes.baseTheme,
    xDomain: {
      min,
      max
    },
    flatLegend: true,
    onPointerUpdate: updatePointerEvent,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter,
    gridLine: {
      visible: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    ticks: 3,
    position: _charts.Position.Left,
    tickFormat: yTickFormat,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }), showAnnotations && /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotations",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: annotations.map(annotation => ({
      dataValue: annotation['@timestamp'],
      header: (0, _formatters.asAbsoluteDateTime)(annotation['@timestamp']),
      details: `${_i18n.i18n.translate('xpack.apm.chart.annotation.version', {
        defaultMessage: 'Version'
      })} ${annotation.text}`
    })),
    style: {
      line: {
        strokeWidth: 1,
        stroke: annotationColor,
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: annotationColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 21
      }
    }),
    markerPosition: _charts.Position.Top,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }), timeseries !== null && timeseries !== void 0 && timeseries.length ? timeseries.map((serie, index) => {
    return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
      timeZone: timeZone,
      key: serie.title,
      id: serie.title,
      name: serie.title,
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: ['y'],
      data: serie.data,
      stackAccessors: ['x'],
      stackMode: yAxisType === 'percentage' ? 'percentage' : undefined,
      color: (0, _viz_colors.getVizColorForIndex)(index, euiTheme),
      curve: _charts.CurveType.CURVE_MONOTONE_X,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 15
      }
    });
  }) :
  /*#__PURE__*/
  // When timeseries is empty, loads an AreaSeries chart to show the default empty message.
  _react.default.createElement(_charts.AreaSeries, {
    id: "empty_chart",
    xAccessor: "x",
    yAccessors: ['y'],
    data: [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  })));
}