"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileServiceTemplate = MobileServiceTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _apm_service_context = require("../../../../context/apm_service/apm_service_context");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _service_anomaly_timeseries_context = require("../../../../context/service_anomaly_timeseries/service_anomaly_timeseries_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_time_range = require("../../../../hooks/use_time_range");
var _get_alerting_capabilities = require("../../../alerting/utils/get_alerting_capabilities");
var _search_bar = require("../../../app/mobile/search_bar");
var _service_icons = require("../../../shared/service_icons");
var _technical_preview_badge = require("../../../shared/technical_preview_badge");
var _apm_main_template = require("../apm_main_template");
var _analyze_data_button = require("../apm_service_template/analyze_data_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/mobile_service_template/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MobileServiceTemplate(props) {
  return /*#__PURE__*/_react.default.createElement(_apm_service_context.ApmServiceContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TemplateWithContext, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  })));
}
function TemplateWithContext({
  title,
  children,
  selectedTabKey,
  searchBarOptions
}) {
  const {
    path: {
      serviceName
    },
    query,
    query: {
      rangeFrom,
      rangeTo,
      environment
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/*');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const router = (0, _use_apm_router.useApmRouter)();
  const tabs = useTabs({
    selectedTabKey
  });
  const selectedTab = tabs === null || tabs === void 0 ? void 0 : tabs.find(({
    isSelected
  }) => isSelected);
  const servicesLink = router.link('/services', {
    query: {
      ...query
    }
  });
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _i18n.i18n.translate('xpack.apm.mobileServices.breadcrumb.title', {
      defaultMessage: 'Service inventory'
    }),
    href: servicesLink
  }, ...(selectedTab ? [{
    title: serviceName,
    href: router.link('/mobile-services/{serviceName}', {
      path: {
        serviceName
      },
      query
    })
  }, {
    title: selectedTab.label,
    href: selectedTab.href
  }] : [])], [query, router, selectedTab, serviceName, servicesLink], {
    omitRootOnServerless: true
  });
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageHeader: {
      tabs,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "apmMainTemplateHeaderServiceName",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 21
        }
      }, serviceName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_service_icons.ServiceIcons, {
        serviceName: serviceName,
        environment: environment,
        start: start,
        end: end,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 19
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_analyze_data_button.AnalyzeDataButton, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 15
        }
      })))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.MobileSearchBar, (0, _extends2.default)({}, searchBarOptions, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_service_anomaly_timeseries_context.ServiceAnomalyTimeseriesContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, children));
}
function useTabs({
  selectedTabKey
}) {
  const {
    core,
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    capabilities
  } = core.application;
  const {
    isAlertingAvailable,
    canReadAlerts
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(plugins, capabilities);
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    path: {
      serviceName
    },
    query: queryFromUrl
  } = (0, _use_apm_params.useApmParams)(`/mobile-services/{serviceName}/${selectedTabKey}`);
  const query = (0, _lodash.omit)(queryFromUrl, 'page', 'pageSize', 'sortField', 'sortDirection');
  const tabs = [{
    key: 'overview',
    href: router.link('/mobile-services/{serviceName}/overview', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.overviewTabLabel', {
      defaultMessage: 'Overview'
    })
  }, {
    key: 'transactions',
    href: router.link('/mobile-services/{serviceName}/transactions', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.transactionsTabLabel', {
      defaultMessage: 'Transactions'
    })
  }, {
    key: 'dependencies',
    href: router.link('/mobile-services/{serviceName}/dependencies', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.dependenciesTabLabel', {
      defaultMessage: 'Dependencies'
    })
  }, {
    key: 'errors-and-crashes',
    href: router.link('/mobile-services/{serviceName}/errors-and-crashes', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.mobileErrorsTabLabel', {
      defaultMessage: 'Errors & Crashes'
    })
  }, {
    key: 'service-map',
    href: router.link('/mobile-services/{serviceName}/service-map', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.serviceMapTabLabel', {
      defaultMessage: 'Service map'
    })
  }, {
    key: 'logs',
    href: router.link('/mobile-services/{serviceName}/logs', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.serviceLogsTabLabel', {
      defaultMessage: 'Logs'
    }),
    append: /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 15
      }
    })
  }, {
    key: 'alerts',
    href: router.link('/mobile-services/{serviceName}/alerts', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.alertsTabLabel', {
      defaultMessage: 'Alerts'
    }),
    hidden: !(isAlertingAvailable && canReadAlerts)
  }, {
    key: 'dashboards',
    href: router.link('/mobile-services/{serviceName}/dashboards', {
      path: {
        serviceName
      },
      query
    }),
    append: /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 15
      }
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.dashboardsTabLabel', {
      defaultMessage: 'Dashboards'
    })
  }];
  return tabs.filter(t => !t.hidden).map(({
    href,
    key,
    label,
    append
  }) => ({
    href,
    label,
    append,
    isSelected: key === selectedTabKey,
    'data-test-subj': `${key}Tab`
  }));
}