"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _dual_range = require("./dual_range");
var _range = require("./range");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />
describe('Single EuiRange', function () {
  var SingleRange = function SingleRange() {
    var _useState = (0, _react.useState)('100'),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];
    var onChange = function onChange(e) {
      setValue(e.currentTarget.value);
    };
    return (0, _react2.jsx)(_range.EuiRange, {
      id: "cy-range-single",
      min: 100,
      max: 200,
      value: value,
      onChange: onChange,
      showLabels: true,
      showRange: true,
      showValue: true,
      valuePrepend: "100 - ",
      "aria-label": "An example of EuiRange with valuePrepend prop"
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(SingleRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the range slider is increased', function () {
      cy.get('input#cy-range-single').focus();
      cy.repeatRealPress('ArrowRight', 10);
      cy.get('output.euiRangeTooltip__value').contains('100 - 110');
      cy.checkAxe();
    });
    it('has zero violations when the range slider is decreased', function () {
      cy.get('input#cy-range-single').focus();
      cy.repeatRealPress('ArrowLeft', 10);
      cy.get('output.euiRangeTooltip__value').contains('100 - 100');
      cy.checkAxe();
    });
  });
});
describe('Dual EuiRange', function () {
  var DualRange = function DualRange() {
    var _useState3 = (0, _react.useState)(['100', '150']),
      _useState4 = _slicedToArray(_useState3, 2),
      dualValue = _useState4[0],
      setDualValue = _useState4[1];
    var onDualChange = function onDualChange(value) {
      setDualValue(value);
    };
    return (0, _react2.jsx)(_dual_range.EuiDualRange, {
      id: "cy-range-dual",
      min: 0,
      max: 300,
      step: 10,
      value: dualValue,
      onChange: onDualChange,
      showLabels: true,
      "aria-label": "An example of EuiDualRange"
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(DualRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the range sliders are adjusted', function () {
      cy.get('div[role="slider"]').first().focus();
      cy.repeatRealPress('ArrowLeft', 3);
      cy.get('div[role="slider"]').first().invoke('attr', 'aria-valuenow').should('eq', '70');
      cy.realPress('Tab');
      cy.get('div[role="slider"]').last().should('have.focus');
      cy.repeatRealPress('ArrowRight', 3);
      cy.get('div[role="slider"]').last().invoke('attr', 'aria-valuenow').should('eq', '180');
      cy.checkAxe();
    });
  });
});
describe('Highlight Area EuiRange', function () {
  var DraggableRange = function DraggableRange() {
    var _useState5 = (0, _react.useState)(['40', '60']),
      _useState6 = _slicedToArray(_useState5, 2),
      dualValue = _useState6[0],
      setDualValue = _useState6[1];
    return (0, _react2.jsx)(_dual_range.EuiDualRange, {
      id: "cy-range-draggable",
      min: 0,
      max: 100,
      step: 1,
      value: dualValue,
      onChange: setDualValue,
      showLabels: true,
      "aria-label": "An example of EuiDualRange with isDraggable='true'",
      isDraggable: true
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(DraggableRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the highlight area is adjusted using arrow keys', function () {
      cy.get('div[role="slider"]').first().focus();
      cy.repeatRealPress('ArrowLeft', 3);
      cy.get('div[role="slider"]').first().invoke('attr', 'aria-valuetext').should('eq', '37, 57');
      cy.checkAxe();
    });
  });
  describe('Drag and drop accessibility check', function () {
    it('has zero violations when the higlight area is dragged using a mouse', function () {
      cy.get('.euiRangeDraggable__inner').realMouseDown({
        position: 'center'
      }).realMouseMove(100, 0, {}).realMouseUp();
      cy.checkAxe();
    });
  });
  describe('EuiRange in a dropdown', function () {
    var InputWithRange = function InputWithRange() {
      var _useState7 = (0, _react.useState)('20'),
        _useState8 = _slicedToArray(_useState7, 2),
        value = _useState8[0],
        setValue = _useState8[1];
      return (0, _react2.jsx)(_range.EuiRange, {
        id: "cy-range-in-dropdown",
        min: 0,
        max: 100,
        value: value,
        onChange: function onChange(e) {
          return setValue(e.currentTarget.value);
        },
        showInput: "inputWithPopover",
        showLabels: true,
        "aria-label": "An example of EuiRange with showInput prop"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(InputWithRange, null));
      cy.get('input#cy-range-in-dropdown').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on first render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility check', function () {
      it('updates the range value using arrow keys with input[type="number"]', function () {
        cy.get('input#cy-range-in-dropdown').focus();
        cy.repeatRealPress('ArrowUp', 10);
        cy.get('input[type="range"]').first().invoke('attr', 'value').should('eq', '30');
        cy.checkAxe();
      });
    });
  });
});