"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_context = require("../../../app_context");
var _generated_config_fields = require("../../connector_detail/components/generated_config_fields");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _new_connector_logic = require("../../new_index/method_connector/new_connector_logic");
var _choose_connector = require("./components/choose_connector");
var _manual_configuration = require("./components/manual_configuration");
var _validate_index_name = require("../utils/validate_index_name");
var _translations = require("../translations");
var _connector_description_popover = require("./components/connector_description_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/create_connector/start_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StartStep = ({
  title,
  selfManagePreference,
  onSelfManagePreferenceChange,
  setCurrentStep,
  error
}) => {
  const isMediumDevice = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm', 'l']);
  const elasticManagedRadioButtonId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'elasticManagedRadioButton'
  });
  const selfManagedRadioButtonId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'selfManagedRadioButton'
  });
  const {
    services: {
      http,
      application
    }
  } = (0, _public.useKibana)();
  const {
    isAgentlessEnabled
  } = (0, _app_context.useAppContext)();
  const {
    rawName,
    canConfigureConnector,
    selectedConnector,
    generatedConfigData,
    isGenerateLoading,
    isCreateLoading,
    isFormDirty
  } = (0, _kea.useValues)((0, _new_connector_logic.NewConnectorLogic)({
    http,
    navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl
  }));
  const {
    setRawName,
    createConnector,
    generateConnectorName,
    setFormDirty
  } = (0, _kea.useActions)((0, _new_connector_logic.NewConnectorLogic)({
    http,
    navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl
  }));
  const {
    connector
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const handleNameChange = e => {
    setRawName(e.target.value);
  };
  const formError = (0, _validate_index_name.isValidIndexName)(rawName) ? error : _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.euiFormRow.nameInputHelpText.lineOne', {
    defaultMessage: '{connectorName} is an invalid index name',
    values: {
      connectorName: rawName
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: "enterprise-search-create-connector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isMediumDevice ? 'column' : 'row',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.euiFormRow.connectorLabel', {
      defaultMessage: 'Connector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_choose_connector.ChooseConnector, {
    selfManaged: selfManagePreference,
    disabled: !!connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: !!error,
    label: _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.euiFormRow.connectorNameLabel', {
      defaultMessage: 'Connector name'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      grow: false,
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 23
      }
    }, formError), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.startStep.namesShouldBeLowercaseTextLabel', {
      defaultMessage: 'The connector name should be lowercase and cannot contain spaces or special characters.'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !!error,
    "data-test-subj": "enterpriseSearchStartStepFieldText",
    fullWidth: true,
    name: "connectorName",
    value: rawName,
    onChange: handleNameChange,
    disabled: !!connector,
    onBlur: () => {
      if (selectedConnector) {
        generateConnectorName({
          connectorName: rawName,
          connectorType: selectedConnector.serviceType,
          isManagedConnector: selectedConnector.isNative,
          http
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.h4.setUpLabel', {
    defaultMessage: 'Setup'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.p.whereDoYouWantLabel', {
    defaultMessage: 'Choose how to deploy and manage your connector:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: elasticManagedRadioButtonId,
    label: _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.euiRadio.elasticManagedLabel', {
      defaultMessage: 'Elastic managed'
    }),
    checked: selfManagePreference === 'native',
    disabled: (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.isNative) === false || !isAgentlessEnabled || isFormDirty,
    onChange: () => onSelfManagePreferenceChange('native'),
    name: "setUp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_description_popover.ConnectorDescriptionPopover, {
    showIsOnlySelfManaged: (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.isNative) === false,
    isNative: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  })), "\xA0 \xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: selfManagedRadioButtonId,
    label: _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.euiRadio.selfManagedLabel', {
      defaultMessage: 'Self-managed'
    }),
    checked: selfManagePreference === 'selfManaged',
    disabled: isFormDirty,
    onChange: () => onSelfManagePreferenceChange('selfManaged'),
    name: "setUp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_description_popover.ConnectorDescriptionPopover, {
    showIsOnlySelfManaged: false,
    isNative: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 17
    }
  }))))), selfManagePreference === 'selfManaged' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'plain' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'default' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.h4.deploymentLabel', {
    defaultMessage: 'Deployment'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) ? 'default' : 'subdued',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.p.youWillStartTheLabel', {
    defaultMessage: "We'll automatically configure your index, API key, and connector ID. Alternatively, create these manually and use a custom configuration."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchStartStepNextButton",
    onClick: () => {
      if (selectedConnector && selectedConnector.name) {
        createConnector({
          isSelfManaged: true
        });
        setFormDirty(true);
        setCurrentStep('deployment');
      }
    },
    fill: true,
    disabled: !canConfigureConnector || !(0, _validate_index_name.isValidIndexName)(rawName) || Boolean(error),
    isLoading: isCreateLoading || isGenerateLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }, _translations.NEXT_BUTTON_LABEL))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'plain' : 'subdued',
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'default' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.h4.configureIndexAndAPILabel', {
    defaultMessage: 'Configure index and API key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'default' : 'subdued',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.p.thisProcessWillCreateLabel', {
    defaultMessage: 'This process will create a new index, API key, and a Connector ID. Optionally you can bring your own configuration as well.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  }), generatedConfigData && connector ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_generated_config_fields.GeneratedConfigFields, {
    apiKey: {
      api_key: generatedConfigData.apiKey.api_key,
      encoded: generatedConfigData.apiKey.encoded,
      id: generatedConfigData.apiKey.id,
      name: generatedConfigData.apiKey.name
    },
    connector: connector,
    isGenerateLoading: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchStartStepGenerateConfigurationButton",
    fill: true,
    onClick: () => {
      setCurrentStep('configure');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 19
    }
  }, _translations.NEXT_BUTTON_LABEL)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-generateConfigButton",
    "data-telemetry-id": "entSearchContent-connector-configuration-generateConfigButton",
    disabled: !canConfigureConnector || !(0, _validate_index_name.isValidIndexName)(rawName) || Boolean(error),
    fill: true,
    iconType: "sparkles",
    isLoading: isGenerateLoading || isCreateLoading,
    onClick: () => {
      setFormDirty(true);
      createConnector({
        isSelfManaged: false
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.connector_detail.configurationConnector.steps.generateApiKey.button.label', {
    defaultMessage: 'Generate configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_manual_configuration.ManualConfiguration, {
    isDisabled: isGenerateLoading || isCreateLoading || !canConfigureConnector || !(0, _validate_index_name.isValidIndexName)(rawName) || Boolean(error),
    selfManagePreference: selfManagePreference,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 21
    }
  })))))));
};
// eslint-disable-next-line import/no-default-export
exports.default = StartStep;
module.exports = exports.default;