"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelaxedCrowdstrikeBaseApiResponseSchema = exports.CrowdstrikeSecretsSchema = exports.CrowdstrikeRTRCommandParamsSchema = exports.CrowdstrikeInitRTRResponseSchema = exports.CrowdstrikeInitRTRParamsSchema = exports.CrowdstrikeHostActionsSchema = exports.CrowdstrikeHostActionsResponseSchema = exports.CrowdstrikeHostActionsParamsSchema = exports.CrowdstrikeGetTokenResponseSchema = exports.CrowdstrikeGetScriptsResponseSchema = exports.CrowdstrikeGetAgentsResponseSchema = exports.CrowdstrikeGetAgentsParamsSchema = exports.CrowdstrikeGetAgentOnlineStatusResponseSchema = exports.CrowdstrikeExecuteRTRResponseSchema = exports.CrowdstrikeConfigSchema = exports.CrowdstrikeBaseApiResponseSchema = exports.CrowdstrikeApiDoNotValidateResponsesSchema = exports.CrowdstrikeActionParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Connector schema
const CrowdstrikeConfigSchema = exports.CrowdstrikeConfigSchema = _zod.z.object({
  url: _zod.z.string()
}).strict();
const CrowdstrikeSecretsSchema = exports.CrowdstrikeSecretsSchema = _zod.z.object({
  clientId: _zod.z.string(),
  clientSecret: _zod.z.string()
}).strict();
const CrowdstrikeApiDoNotValidateResponsesSchema = exports.CrowdstrikeApiDoNotValidateResponsesSchema = _zod.z.any();
const RelaxedCrowdstrikeBaseApiResponseSchema = exports.RelaxedCrowdstrikeBaseApiResponseSchema = _zod.z.object({}).passthrough().optional();
const CrowdstrikeBaseApiResponseSchema = exports.CrowdstrikeBaseApiResponseSchema = _zod.z.object({
  resources: _zod.z.array(_zod.z.any()),
  errors: _zod.z.array(_zod.z.any()).nullable().default(null),
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number().optional(),
    powered_by: _zod.z.string().optional(),
    trace_id: _zod.z.string().optional()
  }).passthrough()
}).passthrough();
const CrowdstrikeGetAgentOnlineStatusResponseSchema = exports.CrowdstrikeGetAgentOnlineStatusResponseSchema = _zod.z.object({
  resources: _zod.z.array(_zod.z.object({
    state: _zod.z.string().optional(),
    id: _zod.z.string().optional(),
    last_seen: _zod.z.string().optional()
  }).passthrough()),
  errors: _zod.z.array(_zod.z.any()).nullable().default(null),
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number().optional(),
    powered_by: _zod.z.string().optional(),
    trace_id: _zod.z.string().optional()
  }).passthrough()
}).passthrough();
const CrowdstrikeGetAgentsResponseSchema = exports.CrowdstrikeGetAgentsResponseSchema = _zod.z.object({
  resources: _zod.z.array(_zod.z.object({
    device_id: _zod.z.string().optional(),
    cid: _zod.z.string().optional(),
    agent_load_flags: _zod.z.string().optional(),
    agent_local_time: _zod.z.string().optional(),
    agent_version: _zod.z.string().optional(),
    bios_manufacturer: _zod.z.string().optional(),
    bios_version: _zod.z.string().optional(),
    config_id_base: _zod.z.string().optional(),
    config_id_build: _zod.z.string().optional(),
    config_id_platform: _zod.z.string().optional(),
    cpu_signature: _zod.z.string().optional(),
    cpu_vendor: _zod.z.string().optional(),
    external_ip: _zod.z.string().optional(),
    mac_address: _zod.z.string().optional(),
    instance_id: _zod.z.string().optional(),
    service_provider: _zod.z.string().optional(),
    service_provider_account_id: _zod.z.string().optional(),
    hostname: _zod.z.string().optional(),
    first_seen: _zod.z.string().optional(),
    last_login_timestamp: _zod.z.string().optional(),
    last_login_user: _zod.z.string().optional(),
    last_login_uid: _zod.z.string().optional(),
    last_seen: _zod.z.string().optional(),
    local_ip: _zod.z.string().optional(),
    major_version: _zod.z.string().optional(),
    minor_version: _zod.z.string().optional(),
    os_version: _zod.z.string().optional(),
    platform_id: _zod.z.string().optional(),
    platform_name: _zod.z.string().optional(),
    policies: _zod.z.array(_zod.z.object({
      policy_type: _zod.z.string().optional(),
      policy_id: _zod.z.string().optional(),
      applied: _zod.z.boolean().optional(),
      settings_hash: _zod.z.string().optional(),
      assigned_date: _zod.z.string().optional(),
      applied_date: _zod.z.string().optional(),
      rule_groups: _zod.z.any().optional()
    }).passthrough()).optional(),
    reduced_functionality_mode: _zod.z.string().optional(),
    device_policies: _zod.z.object({
      prevention: _zod.z.object({
        policy_type: _zod.z.string().optional(),
        policy_id: _zod.z.string().optional(),
        applied: _zod.z.boolean().optional(),
        settings_hash: _zod.z.string().optional(),
        assigned_date: _zod.z.string().optional(),
        applied_date: _zod.z.string().optional(),
        rule_groups: _zod.z.any().optional()
      }).passthrough(),
      sensor_update: _zod.z.object({
        policy_type: _zod.z.string().optional(),
        policy_id: _zod.z.string().optional(),
        applied: _zod.z.boolean().optional(),
        settings_hash: _zod.z.string().optional(),
        assigned_date: _zod.z.string().optional(),
        applied_date: _zod.z.string().optional(),
        uninstall_protection: _zod.z.string().optional()
      }).passthrough(),
      global_config: _zod.z.object({
        policy_type: _zod.z.string().optional(),
        policy_id: _zod.z.string().optional(),
        applied: _zod.z.boolean().optional(),
        settings_hash: _zod.z.string().optional(),
        assigned_date: _zod.z.string().optional(),
        applied_date: _zod.z.string().optional()
      }).passthrough(),
      remote_response: _zod.z.object({
        policy_type: _zod.z.string().optional(),
        policy_id: _zod.z.string().optional(),
        applied: _zod.z.boolean().optional(),
        settings_hash: _zod.z.string().optional(),
        assigned_date: _zod.z.string().optional(),
        applied_date: _zod.z.string().optional()
      }).passthrough()
    }).passthrough().optional(),
    groups: _zod.z.array(_zod.z.any()).optional(),
    group_hash: _zod.z.string().optional(),
    product_type_desc: _zod.z.string().optional(),
    provision_status: _zod.z.string().optional(),
    serial_number: _zod.z.string().optional(),
    status: _zod.z.string().optional(),
    system_manufacturer: _zod.z.string().optional(),
    system_product_name: _zod.z.string().optional(),
    tags: _zod.z.array(_zod.z.any()).optional(),
    modified_timestamp: _zod.z.any(),
    meta: _zod.z.object({
      version: _zod.z.string().optional(),
      version_string: _zod.z.string().optional()
    }).passthrough().optional(),
    zone_group: _zod.z.string().optional(),
    kernel_version: _zod.z.string().optional(),
    chassis_type: _zod.z.string().optional(),
    chassis_type_desc: _zod.z.string().optional(),
    connection_ip: _zod.z.string().optional(),
    default_gateway_ip: _zod.z.string().optional(),
    connection_mac_address: _zod.z.string().optional(),
    linux_sensor_mode: _zod.z.string().optional(),
    deployment_type: _zod.z.string().optional()
  }).passthrough()),
  errors: _zod.z.array(_zod.z.any()).nullable().default(null),
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number().optional(),
    powered_by: _zod.z.string().optional(),
    trace_id: _zod.z.string().optional()
  }).passthrough()
}).passthrough();
const CrowdstrikeHostActionsResponseSchema = exports.CrowdstrikeHostActionsResponseSchema = _zod.z.object({
  resources: _zod.z.array(_zod.z.object({
    id: _zod.z.string().optional(),
    path: _zod.z.string().optional()
  }).passthrough()),
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number().optional(),
    powered_by: _zod.z.string().optional(),
    trace_id: _zod.z.string().optional()
  }).passthrough(),
  errors: _zod.z.array(_zod.z.any()).nullable().default(null)
}).passthrough();

// TODO temporary any value
const CrowdstrikeRTRCommandParamsSchema = exports.CrowdstrikeRTRCommandParamsSchema = _zod.z.any();
const CrowdstrikeHostActionsParamsSchema = exports.CrowdstrikeHostActionsParamsSchema = _zod.z.object({
  command: _zod.z.enum(['contain', 'lift_containment']),
  actionParameters: _zod.z.object({}).passthrough().optional(),
  ids: _zod.z.array(_zod.z.string()),
  alertIds: _zod.z.array(_zod.z.string()).optional(),
  comment: _zod.z.string().optional()
}).strict();
const CrowdstrikeGetAgentsParamsSchema = exports.CrowdstrikeGetAgentsParamsSchema = _zod.z.object({
  ids: _zod.z.array(_zod.z.string())
}).strict();
const CrowdstrikeGetTokenResponseSchema = exports.CrowdstrikeGetTokenResponseSchema = _zod.z.object({
  access_token: _zod.z.string(),
  expires_in: _zod.z.coerce.number(),
  token_type: _zod.z.string(),
  id_token: _zod.z.string().optional(),
  issued_token_type: _zod.z.string().optional(),
  refresh_token: _zod.z.string().optional(),
  scope: _zod.z.string().optional()
}).passthrough();
const CrowdstrikeHostActionsSchema = exports.CrowdstrikeHostActionsSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.HOST_ACTIONS),
  subActionParams: CrowdstrikeHostActionsParamsSchema
}).strict();
const CrowdstrikeActionParamsSchema = exports.CrowdstrikeActionParamsSchema = CrowdstrikeHostActionsSchema;
const CrowdstrikeInitRTRResponseSchema = exports.CrowdstrikeInitRTRResponseSchema = _zod.z.object({
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number().optional(),
    powered_by: _zod.z.string().optional(),
    trace_id: _zod.z.string().optional()
  }).passthrough().optional(),
  batch_id: _zod.z.string().optional(),
  resources: _zod.z.record(_zod.z.string(), _zod.z.object({
    session_id: _zod.z.string().optional(),
    task_id: _zod.z.string().optional(),
    complete: _zod.z.boolean().optional(),
    stdout: _zod.z.string().optional(),
    stderr: _zod.z.string().optional(),
    base_command: _zod.z.string().optional(),
    aid: _zod.z.string().optional(),
    errors: _zod.z.array(_zod.z.any()).optional(),
    query_time: _zod.z.coerce.number().optional(),
    offline_queued: _zod.z.boolean().optional()
  }).passthrough()).optional(),
  errors: _zod.z.array(_zod.z.any()).optional()
}).passthrough();
const CrowdstrikeInitRTRParamsSchema = exports.CrowdstrikeInitRTRParamsSchema = _zod.z.object({
  endpoint_ids: _zod.z.array(_zod.z.string())
}).strict();
const CrowdstrikeExecuteRTRResponseSchema = exports.CrowdstrikeExecuteRTRResponseSchema = _zod.z.object({
  combined: _zod.z.object({
    resources: _zod.z.record(_zod.z.string(), _zod.z.object({
      session_id: _zod.z.string(),
      task_id: _zod.z.string(),
      complete: _zod.z.boolean(),
      stdout: _zod.z.string(),
      stderr: _zod.z.string(),
      base_command: _zod.z.string(),
      aid: _zod.z.string(),
      errors: _zod.z.array(_zod.z.any()),
      query_time: _zod.z.coerce.number(),
      offline_queued: _zod.z.boolean()
    }).passthrough())
  }).passthrough(),
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number(),
    powered_by: _zod.z.string(),
    trace_id: _zod.z.string()
  }).passthrough(),
  errors: _zod.z.array(_zod.z.any()).nullable().default(null)
}).passthrough();
const CrowdstrikeGetScriptsResponseSchema = exports.CrowdstrikeGetScriptsResponseSchema = _zod.z.object({
  meta: _zod.z.object({
    query_time: _zod.z.coerce.number().optional(),
    powered_by: _zod.z.string().optional(),
    trace_id: _zod.z.string().optional()
  }).passthrough().optional(),
  resources: _zod.z.array(_zod.z.object({
    content: _zod.z.string().optional(),
    created_by: _zod.z.string().optional(),
    created_by_uuid: _zod.z.string().optional(),
    created_timestamp: _zod.z.string().optional(),
    file_type: _zod.z.string().optional(),
    id: _zod.z.string().optional(),
    description: _zod.z.string().optional(),
    modified_by: _zod.z.string().optional(),
    modified_timestamp: _zod.z.string().optional(),
    name: _zod.z.string().optional(),
    permission_type: _zod.z.string().optional(),
    platform: _zod.z.array(_zod.z.string()).optional(),
    run_attempt_count: _zod.z.coerce.number().optional(),
    run_success_count: _zod.z.coerce.number().optional(),
    sha256: _zod.z.string().optional(),
    size: _zod.z.coerce.number().optional(),
    write_access: _zod.z.boolean().optional()
  }).passthrough()).optional(),
  errors: _zod.z.array(_zod.z.any()).optional()
}).passthrough();