"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityStatistics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _use_get_severity_status_color = require("@kbn/cloud-security-posture/src/hooks/use_get_severity_status_color");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _vuln_counter_card = require("../../components/vuln_counter_card");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _compact_formatted_number = require("../../components/compact_formatted_number");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerability_dashboard/vulnerability_statistics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VulnerabilityStatistics = () => {
  const {
    getSeverityStatusColor
  } = (0, _use_get_severity_status_color.useGetSeverityStatusColor)();
  const navToVulnerabilities = (0, _use_navigate_findings.useNavigateNativeVulnerabilities)();
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  const stats = (0, _react.useMemo)(() => {
    var _getVulnerabilityDash, _getVulnerabilityDash2, _getVulnerabilityDash3, _getVulnerabilityDash4, _getVulnerabilityDash5;
    return [{
      id: 'critical-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash === void 0 ? void 0 : _getVulnerabilityDash.cnvmStatistics.criticalCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 11
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL),
        textSize: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.criticalTitle', {
        defaultMessage: 'Critical'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL
        });
      }
    }, {
      id: 'high-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash2 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash2 === void 0 ? void 0 : _getVulnerabilityDash2.cnvmStatistics.highCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 11
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH),
        textSize: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.highTitle', {
        defaultMessage: 'High'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH
        });
      }
    }, {
      id: 'medium-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash3 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash3 === void 0 ? void 0 : _getVulnerabilityDash3.cnvmStatistics.mediumCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM),
        textSize: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.mediumTitle', {
        defaultMessage: 'Medium'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM
        });
      }
    }, {
      id: 'cloud-regions-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash4 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash4 === void 0 ? void 0 : _getVulnerabilityDash4.cnvmStatistics.cloudAccounts,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }),
      description: _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.cloudRegionTitle', {
        defaultMessage: 'Cloud Accounts'
      })
    }, {
      id: 'assets-scanned-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash5 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash5 === void 0 ? void 0 : _getVulnerabilityDash5.cnvmStatistics.resourcesScanned,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 11
        }
      }),
      description: _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.resourcesScannedTitle', {
        defaultMessage: 'Resources Scanned'
      })
    }];
  }, [getVulnerabilityDashboard.data, navToVulnerabilities, getSeverityStatusColor]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, stats.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: stat.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_vuln_counter_card.VulnCounterCard, (0, _extends2.default)({}, stat, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })))));
};
exports.VulnerabilityStatistics = VulnerabilityStatistics;