"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTableUtilityBar = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../common/constants");
var _use_on_refresh_cases = require("./use_on_refresh_cases");
var _use_bulk_actions = require("./use_bulk_actions");
var _use_cases_context = require("../cases_context/use_cases_context");
var _columns_popover = require("./columns_popover");
var _use_cases_local_storage = require("../../common/use_cases_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/utility_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CasesTableUtilityBar = exports.CasesTableUtilityBar = /*#__PURE__*/_react2.default.memo(({
  isSelectorView,
  totalCases,
  selectedCases,
  deselectCases,
  pagination,
  selectedColumns,
  onSelectedColumnsChange,
  onClearFilters,
  showClearFiltersButton
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const refreshCases = (0, _use_on_refresh_cases.useRefreshCases)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const [isMessageDismissed, setIsMessageDismissed] = (0, _react2.useState)(false);
  const localStorageKey = `cases.utilityBar.hideMaxLimitWarning`;
  const [doNotShowAgain, setDoNotShowAgain] = (0, _use_cases_local_storage.useCasesLocalStorage)(localStorageKey, false);
  const togglePopover = (0, _react2.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react2.useCallback)(() => setIsPopoverOpen(false), []);
  const toggleWarning = (0, _react2.useCallback)(() => setIsMessageDismissed(!isMessageDismissed), [isMessageDismissed]);
  const onRefresh = (0, _react2.useCallback)(() => {
    deselectCases();
    refreshCases();
  }, [deselectCases, refreshCases]);
  const {
    panels,
    modals,
    flyouts
  } = (0, _use_bulk_actions.useBulkActions)({
    selectedCases,
    onAction: closePopover,
    onActionSuccess: onRefresh
  });
  const handleNotShowAgain = () => {
    setDoNotShowAgain(true);
  };

  /**
   * At least update or delete permissions needed to show bulk actions.
   * Granular permission check for each action is performed
   * in the useBulkActions hook.
   */
  const showBulkActions = (permissions.update || permissions.delete || permissions.reopenCase || permissions.assign) && selectedCases.length > 0;
  const visibleCases = pagination !== null && pagination !== void 0 && pagination.pageSize && totalCases > pagination.pageSize ? pagination.pageSize : totalCases;
  const hasReachedMaxCases = pagination.pageSize && totalCases >= _constants.MAX_DOCS_PER_PAGE && pagination.pageSize * (pagination.pageIndex + 1) >= _constants.MAX_DOCS_PER_PAGE;
  const renderMaxLimitWarning = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "default",
    size: "m",
    css: (0, _react.css)`
              margin-top: ${euiTheme.size.xs};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, i18n.MAX_CASES(_constants.MAX_DOCS_PER_PAGE))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "warning",
    "data-test-subj": "dismiss-warning",
    onClick: toggleWarning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, i18n.DISMISS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "warning",
    "data-test-subj": "do-not-show-warning",
    onClick: handleNotShowAgain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, i18n.NOT_SHOW_AGAIN)));
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    css: (0, _react.css)`
            border-bottom: ${euiTheme.border.thin};
            padding-top: ${euiTheme.size.s};
            padding-bottom: ${euiTheme.size.s};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-table-case-count",
    grow: false,
    css: (0, _react.css)`
                  border-right: ${euiTheme.border.thin};
                  padding-right: ${euiTheme.size.s};
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, i18n.SHOWING_CASES(totalCases, visibleCases))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-table-utility-bar-actions",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }, !isSelectorView && showBulkActions && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-table-selected-case-count",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 25
    }
  }, i18n.SHOWING_SELECTED_CASES(selectedCases.length))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    "data-test-subj": "case-table-bulk-actions-popover",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      onClick: togglePopover,
      size: "xs",
      iconSide: "right",
      iconType: "arrowDown",
      flush: "left",
      "data-test-subj": "case-table-bulk-actions-link-icon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 29
      }
    }, i18n.BULK_ACTIONS),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 0,
    "data-test-subj": "case-table-bulk-actions-context-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 27
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onRefresh,
    size: "xs",
    iconSide: "left",
    iconType: "refresh",
    flush: "left",
    "data-test-subj": "all-cases-refresh-link-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 21
    }
  }, i18n.REFRESH)), showClearFiltersButton ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClearFilters,
    size: "xs",
    iconSide: "left",
    iconType: "cross",
    flush: "left",
    "data-test-subj": "all-cases-clear-filters-link-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 23
    }
  }, i18n.CLEAR_FILTERS)) : null)))), !isSelectorView && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_columns_popover.ColumnsPopover, {
    selectedColumns: selectedColumns,
    onSelectedColumnsChange: onSelectedColumnsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }))), modals, flyouts, hasReachedMaxCases && !isMessageDismissed && !doNotShowAgain && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: renderMaxLimitWarning(),
    color: "warning",
    size: "s",
    "data-test-subj": "all-cases-maximum-limit-warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  })));
});
CasesTableUtilityBar.displayName = 'CasesTableUtilityBar';