"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemGrid = void 0;
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/item_grid/item_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PER_ROW_DEFAULT = 6;

// We need this type in order to define propTypes on the object.  It's a bit redundant,
// but TS needs to know that ItemGrid can have propTypes defined on it.

const ItemGrid = exports.ItemGrid = function ItemGridFunc({
  items = [],
  itemsPerRow = PER_ROW_DEFAULT,
  children
}) {
  const reducedRows = items.reduce((rows, item) => {
    let end = (0, _lodash.last)(rows);
    if (end && end.length >= itemsPerRow) {
      rows.push([]);
    }
    end = (0, _lodash.last)(rows);
    if (end) {
      end.push(children(item));
    }
    return rows;
  }, [[]]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, reducedRows.map((row, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: `item-grid-row-${i}`,
    className: "item-grid-row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, row)));
};
ItemGrid.propTypes = {
  items: _propTypes.default.array,
  itemsPerRow: _propTypes.default.number,
  children: _propTypes.default.func.isRequired
};