"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfallEmbeddable = TraceWaterfallEmbeddable;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../hooks/use_fetcher");
var _loading = require("./loading");
var _trace_waterfall = require("../../components/shared/trace_waterfall");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/embeddable/trace_waterfall/trace_waterfall_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TraceWaterfallEmbeddable({
  serviceName,
  rangeFrom,
  rangeTo,
  traceId,
  scrollElement,
  onNodeClick,
  getRelatedErrorsHref,
  onErrorClick,
  mode
}) {
  const isFiltered = mode === 'filtered';
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/unified_traces/{traceId}', {
      params: {
        path: {
          traceId
        },
        query: {
          start: rangeFrom,
          end: rangeTo,
          serviceName: isFiltered ? serviceName : undefined
        }
      }
    });
  }, [rangeFrom, rangeTo, traceId, isFiltered, serviceName]);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 12
      }
    });
  }
  if (data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      "data-test-subj": "TraceWaterfallEmbeddableNoData",
      color: "danger",
      size: "s",
      title: _i18n.i18n.translate('xpack.apm.traceWaterfallEmbeddable.noDataCalloutLabel', {
        defaultMessage: 'Trace waterfall could not be loaded.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_trace_waterfall.TraceWaterfall, {
    traceItems: data.traceItems,
    onClick: onNodeClick,
    scrollElement: scrollElement,
    getRelatedErrorsHref: getRelatedErrorsHref,
    isEmbeddable: true,
    showLegend: true,
    serviceName: serviceName,
    onErrorClick: onErrorClick,
    isFiltered: isFiltered,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
}