"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAggregateQueryRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAggregateQueryRequest = ({
  search,
  default_search_operator: defaultSearchOperator,
  search_fields: searchFields,
  has_reference: hasReference,
  rule_type_ids: ruleTypeIds,
  consumers,
  filter
}) => ({
  defaultSearchOperator,
  ...(hasReference ? {
    hasReference
  } : {}),
  ...(searchFields ? {
    searchFields
  } : {}),
  ...(search ? {
    search
  } : {}),
  ...(ruleTypeIds ? {
    ruleTypeIds
  } : {}),
  ...(consumers ? {
    consumers
  } : {}),
  ...(filter ? {
    filter
  } : {})
});
exports.transformAggregateQueryRequest = transformAggregateQueryRequest;