"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_MULTI_VALUE_CLICK = void 0;
exports.createMultiValueClickActionDefinition = createMultiValueClickActionDefinition;
var _esQuery = require("@kbn/es-query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ACTION_MULTI_VALUE_CLICK = exports.ACTION_MULTI_VALUE_CLICK = 'ACTION_MULTI_VALUE_CLICK';
function createMultiValueClickActionDefinition(getStartServices) {
  return {
    type: ACTION_MULTI_VALUE_CLICK,
    id: ACTION_MULTI_VALUE_CLICK,
    shouldAutoExecute: async () => true,
    isCompatible: async context => {
      const {
        createFiltersFromMultiValueClickAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./filters')));
      const filters = await createFiltersFromMultiValueClickAction(context.data);
      return Boolean(filters);
    },
    execute: async ({
      data
    }) => {
      const {
        createFiltersFromMultiValueClickAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./filters')));
      const filters = await createFiltersFromMultiValueClickAction(data);
      if (!filters || (filters === null || filters === void 0 ? void 0 : filters.length) === 0) return;
      const {
        filterManager,
        timefilter: {
          timefilter
        }
      } = getStartServices().query;
      if (data.timeFieldName) {
        const {
          timeRangeFilter,
          restOfFilters
        } = (0, _esQuery.extractTimeFilter)(data.timeFieldName, filters);
        filterManager.addFilters(restOfFilters);
        if (timeRangeFilter) {
          timefilter.setTime((0, _esQuery.convertRangeFilterToTimeRange)(timeRangeFilter));
        }
      } else {
        filterManager.addFilters(filters);
      }
    }
  };
}