"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStyleProperty = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Utility function to get the value of a style property of an element.
 *
 * @param element - the element to get the property value of.
 * @param property - the property to get the value of.
 * @returns the value of the property.
 */
const getStyleProperty = (element, property) => {
  if (typeof window === 'undefined') return 0;
  const styles = window.getComputedStyle(element);
  const propertyValue = styles.getPropertyValue(property);
  return parseFloat(propertyValue);
};
exports.getStyleProperty = getStyleProperty;