"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_layout_width = require("../../hooks/use_layout_width");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _use_scroll = require("../../hooks/use_scroll");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/side_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * **Border and shadow**
 *
 * For instance, only plain or transparent panels can have a border and/or shadow.
 * Source: {@link https://eui.elastic.co/docs/components/containers/panel/}
 */
const getWrapperStyles = theme => (0, _react2.css)`
  box-sizing: border-box;
  border-right: ${theme.border.width.thin} ${theme.colors.borderBaseSubdued} solid;
  display: flex;
  flex-direction: column;
  width: ${_use_layout_width.SIDE_PANEL_WIDTH}px;
`;
/**
 * Side navigation panel that opens on mouse click if the primary menu item contains a submenu.
 * Shows only in expanded mode.
 */
const SidePanel = ({
  children,
  footer,
  openerNode
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const scrollStyles = (0, _use_scroll.useScroll)();
  const wrapperStyles = (0, _react.useMemo)(() => getWrapperStyles(euiTheme), [euiTheme]);
  const panelRef = ref => {
    if (ref) {
      const elements = (0, _get_focusable_elements.getFocusableElements)(ref);
      (0, _update_tab_indices.updateTabIndices)(elements);
    }
  };
  const navigationPanelStyles = (0, _react.useMemo)(() => (0, _react2.css)`
      ${scrollStyles}
    `, [scrollStyles]);
  const sidePanelClassName = `${_constants.NAVIGATION_SELECTOR_PREFIX}-sidePanel`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.sidePanelAriaLabel', {
      defaultMessage: `Side panel for {label}`,
      values: {
        label: openerNode.label
      }
    }),
    borderRadius: "none",
    className: sidePanelClassName // Used in Storybook to limit the height of the panel
    ,
    css: wrapperStyles,
    "data-test-subj": `${sidePanelClassName} ${sidePanelClassName}_${openerNode.id}`,
    hasShadow: false,
    role: "region",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    css: navigationPanelStyles,
    "data-test-subj": `${_constants.NAVIGATION_SELECTOR_PREFIX}-panelContent`,
    onKeyDown: _handle_roving_index.handleRovingIndex,
    panelRef: panelRef,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    "data-test-subj": `${_constants.NAVIGATION_SELECTOR_PREFIX}-panelFooter`,
    paddingSize: "none",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, footer));
};
exports.SidePanel = SidePanel;